/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.structs.Color;
import java.io.IOException;
import java.io.InputStream;

public abstract class Image
extends Symbol {

    public static class JPEG
    extends Image {
        protected InputStream jpegIn;
        protected byte[] jpegData;

        public JPEG(InputStream inputStream) {
            this.jpegIn = inputStream;
        }

        public JPEG(byte[] byArray) {
            this.jpegData = byArray;
        }

        public byte[] getImageData() {
            return this.jpegData;
        }

        protected int defineSymbol(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
            int n = this.getNextId(movie);
            if (this.jpegData != null) {
                sWFTagTypes2.tagDefineBitsJPEG2(n, this.jpegData);
            } else if (this.jpegIn != null) {
                sWFTagTypes2.tagDefineBitsJPEG2(n, this.jpegIn);
            }
            return n;
        }
    }

    public static class Lossless
    extends Image {
        protected byte[] imageData;
        protected Color[] colorTable;
        protected double width;
        protected double height;
        protected boolean hasAlpha;
        protected int format;

        public Lossless(Color[] colorArray, byte[] byArray, double d, double d2, boolean bl, int n) {
            this.colorTable = colorArray;
            this.imageData = byArray;
            this.width = d;
            this.height = d2;
            this.hasAlpha = bl;
            this.format = n;
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public Color[] getColorTable() {
            return this.colorTable;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public int getFormat() {
            return this.format;
        }

        protected int defineSymbol(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
            int n = this.getNextId(movie);
            if (this.hasAlpha) {
                sWFTagTypes2.tagDefineBitsLossless2(n, this.format, (int)this.width, (int)this.height, this.colorTable, this.imageData);
            } else {
                sWFTagTypes2.tagDefineBitsLossless(n, this.format, (int)this.width, (int)this.height, this.colorTable, this.imageData);
            }
            return n;
        }
    }
}

