/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.movie.Image;
import com.anotherbigidea.flash.movie.Shape;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.Color;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public class ImageUtil {
    public static byte[] normalizeJPEG(InputStream inputStream, int[] nArray) throws IOException {
        JPEGImageDecoder jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)inputStream);
        BufferedImage bufferedImage = jPEGImageDecoder.decodeAsBufferedImage();
        if (nArray != null && nArray.length >= 2) {
            nArray[0] = jPEGImageDecoder.getJPEGDecodeParam().getWidth();
            nArray[1] = jPEGImageDecoder.getJPEGDecodeParam().getHeight();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(255);
        byteArrayOutputStream.write(217);
        byteArrayOutputStream.write(255);
        byteArrayOutputStream.write(216);
        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)byteArrayOutputStream);
        jPEGImageEncoder.encode(bufferedImage);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static Shape shapeForImage(InputStream inputStream, int[] nArray) throws IOException {
        if (nArray == null || nArray.length < 2) {
            nArray = new int[2];
        }
        byte[] byArray = ImageUtil.normalizeJPEG(inputStream, nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        Image.JPEG jPEG = new Image.JPEG(byArray);
        return ImageUtil.shapeForImage(jPEG, n, n2);
    }

    public static Shape shapeForImage(Image image, double d, double d2) {
        Shape shape = new Shape();
        Transform transform = new Transform(20.0, 20.0, 0.0, 0.0);
        shape.defineFillStyle(image, transform, true);
        shape.setRightFillStyle(1);
        shape.setLineStyle(0);
        shape.line(d, 0.0);
        shape.line(d, d2);
        shape.line(0.0, d2);
        shape.line(0.0, 0.0);
        return shape;
    }

    public static Image.Lossless createLosslessImage(java.awt.Image image, int n, boolean bl) {
        Color[] colorArray;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = image.getWidth(null);
        int n7 = image.getHeight(null);
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n6, n7, true);
        pixelGrabber.startGrabbing();
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        int n8 = 0;
        switch (n) {
            case 3: {
                n8 = 1;
                break;
            }
            case 4: {
                n8 = 2;
                break;
            }
            default: {
                n8 = 4;
            }
        }
        int n9 = n6 * n8;
        int n10 = n9 % 4;
        if (n10 > 0) {
            n9 += 4 - n10;
        }
        byte[] byArray = new byte[n7 * n9];
        HashMap<Integer, Integer> hashMap = n == 5 ? null : new HashMap<Integer, Integer>();
        for (int i = 0; i < n7; ++i) {
            int n11 = i * n6;
            int n12 = i * n9;
            for (n5 = 0; n5 < n6; ++n5) {
                n4 = nArray[n11 + n5];
                n3 = n12 + n5 * n8;
                if (n == 5) {
                    byArray[n3] = bl ? (int)(n4 >> 24) : -1;
                    byArray[n3 + 1] = (byte)(n4 >> 16 & 0xFF);
                    byArray[n3 + 2] = (byte)(n4 >> 8 & 0xFF);
                    byArray[n3 + 3] = (byte)(n4 & 0xFF);
                    continue;
                }
                Integer n13 = new Integer(n4);
                Integer n14 = (Integer)hashMap.get(n13);
                if (n14 == null) {
                    n14 = new Integer(hashMap.size());
                    hashMap.put(n13, n14);
                }
                n2 = n14;
                if (n == 3) {
                    byArray[n3] = (byte)n2;
                    continue;
                }
                byArray[n3] = (byte)(n2 >> 8 & 0xFF);
                byArray[n3 + 1] = (byte)(n2 & 0xFF);
            }
        }
        Color[] colorArray2 = colorArray = n == 5 ? null : new Color[hashMap.size()];
        if (colorArray != null) {
            for (Integer n15 : hashMap.keySet()) {
                n5 = n15;
                n4 = (Integer)hashMap.get(n15);
                n3 = n5 >> 24 & 0xFF;
                int n16 = n5 >> 16 & 0xFF;
                int n17 = n5 >> 8 & 0xFF;
                n2 = n5 & 0xFF;
                Color color = bl ? new AlphaColor(n16, n17, n2, n3) : new Color(n16, n17, n2);
                colorArray[n4] = color;
                System.out.println("Color " + n4 + " = " + color);
            }
        }
        return new Image.Lossless(colorArray, byArray, n6, n7, bl, n);
    }
}

