/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.Actions;
import com.anotherbigidea.flash.movie.Instance;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaTransform;
import java.io.IOException;

public class Placement {
    protected boolean isAlteration;
    protected boolean isReplacement;
    protected int frameNumber;
    protected Instance instance;
    protected Transform matrix;
    protected AlphaTransform cxform;
    protected String name;
    protected int ratio = -1;
    protected int clipDepth = -1;
    protected boolean isRemove = false;
    protected Actions[] clipActions;
    protected Symbol symbolToFree;

    public boolean isUndefineSymbol() {
        return this.symbolToFree != null;
    }

    public boolean isReplacement() {
        return this.isReplacement;
    }

    public boolean isAlteration() {
        return this.isAlteration;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public Transform getTransform() {
        return this.matrix;
    }

    public AlphaTransform getColorTransform() {
        return this.cxform;
    }

    public String getName() {
        return this.name;
    }

    public int getRatio() {
        return this.ratio;
    }

    public int getClipDepth() {
        return this.clipDepth;
    }

    public boolean isRemove() {
        return this.isRemove;
    }

    public Actions[] getClipActions() {
        return this.clipActions;
    }

    public void setClipActions(Actions[] actionsArray) {
        this.clipActions = actionsArray;
    }

    protected Placement(Symbol symbol) {
        this.symbolToFree = symbol;
    }

    protected Placement(Instance instance, int n) {
        this.instance = instance;
        this.frameNumber = n;
        this.isRemove = true;
    }

    protected Placement(Instance instance, Transform transform, AlphaTransform alphaTransform, String string, int n, int n2, int n3, boolean bl, boolean bl2, Actions[] actionsArray) {
        this.instance = instance;
        this.frameNumber = n3;
        this.matrix = transform;
        this.cxform = alphaTransform;
        this.name = string;
        this.ratio = n;
        this.clipDepth = n2;
        this.isRemove = false;
        this.isAlteration = bl;
        this.isReplacement = bl2;
        this.clipActions = actionsArray;
    }

    protected void flushDefinitions(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        if (this.symbolToFree != null) {
            return;
        }
        if (!this.isAlteration && !this.isRemove) {
            Symbol symbol = this.instance.getSymbol();
            symbol.define(movie, sWFTagTypes, sWFTagTypes2);
        }
    }

    protected void write(Movie movie, SWFTagTypes sWFTagTypes, SWFTagTypes sWFTagTypes2) throws IOException {
        if (this.symbolToFree != null) {
            int n = this.symbolToFree.getId();
            sWFTagTypes2.tagFreeCharacter(n);
            return;
        }
        int n = this.instance.getDepth();
        if (n < 0) {
            return;
        }
        if (this.isRemove) {
            sWFTagTypes2.tagRemoveObject2(n);
            return;
        }
        if (!this.isAlteration) {
            Symbol symbol = this.instance.getSymbol();
            int n2 = symbol.define(movie, sWFTagTypes2, sWFTagTypes);
            int n3 = 0;
            if (this.clipActions != null && this.clipActions.length > 0) {
                for (int i = 0; i < this.clipActions.length; ++i) {
                    n3 |= this.clipActions[i].getConditions();
                }
            }
            SWFActions sWFActions = sWFTagTypes2.tagPlaceObject2(this.isReplacement, this.clipDepth, n, n2, this.matrix, this.cxform, this.ratio, this.name, n3);
            if (this.clipActions != null && this.clipActions.length > 0) {
                for (int i = 0; i < this.clipActions.length; ++i) {
                    sWFActions.start(this.clipActions[i].getConditions()).blob(this.clipActions[i].bytes);
                }
                sWFActions.done();
            }
        } else {
            sWFTagTypes2.tagPlaceObject2(true, this.clipDepth, n, -1, this.matrix, this.cxform, this.ratio, null, 0);
        }
    }
}

