/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.io.InStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ActionParser
implements SWFActionCodes {
    protected SWFActionBlock mBlock;
    protected int mFlashVersion;
    protected int mStartOffset;

    public ActionParser(SWFActionBlock sWFActionBlock, int n) {
        this.mBlock = sWFActionBlock;
        this.mFlashVersion = n;
    }

    public synchronized void parse(byte[] byArray) throws IOException {
        this.parse(new InStream(byArray));
    }

    public synchronized void parse(InStream inStream) throws IOException {
        this.mStartOffset = (int)inStream.getBytesRead();
        BlockParser blockParser = new BlockParser(this.mBlock, -1, inStream, this.mFlashVersion);
        blockParser.parse();
    }

    private class BlockParser
    implements SWFActionCodes {
        private SWFActionBlock mBlock;
        private int mBlockSize;
        private InStream mIn;
        private int mInitBytesRead;
        private int mFlashVersion;
        protected String mStringEncoding = "UTF-8";
        private int mWaitForFrameIndex = 0;
        private List mWaitForFrameTargets;

        private String newWaitForFrameTarget(int n) {
            if (this.mWaitForFrameTargets == null) {
                this.mWaitForFrameTargets = new ArrayList();
            }
            WaitForFrameTarget waitForFrameTarget = new WaitForFrameTarget(n, "w" + this.mWaitForFrameIndex++);
            this.mWaitForFrameTargets.add(waitForFrameTarget);
            return waitForFrameTarget.targetLabel;
        }

        BlockParser(SWFActionBlock sWFActionBlock, int n, InStream inStream, int n2) {
            this.mBlock = sWFActionBlock;
            this.mBlockSize = n;
            this.mIn = inStream;
            this.mInitBytesRead = (int)inStream.getBytesRead();
            this.mFlashVersion = n2;
            if (n2 < 6) {
                this.mStringEncoding = "US-ASCII";
            }
        }

        private String makeLabel(int n) {
            String string = Integer.toString(n + this.mInitBytesRead - ActionParser.this.mStartOffset);
            if (string.length() < 4) {
                string = "0000".substring(0, 4 - string.length()) + string;
            }
            return string;
        }

        private void applyWaitForFrameTargets() throws IOException {
            if (this.mWaitForFrameTargets == null || this.mWaitForFrameTargets.isEmpty()) {
                return;
            }
            Iterator iterator = this.mWaitForFrameTargets.iterator();
            while (iterator.hasNext()) {
                WaitForFrameTarget waitForFrameTarget = (WaitForFrameTarget)iterator.next();
                if (waitForFrameTarget.actionsToSkip == 0) {
                    this.mBlock.jumpLabel(waitForFrameTarget.targetLabel);
                    iterator.remove();
                    continue;
                }
                --waitForFrameTarget.actionsToSkip;
            }
        }

        void parse() throws IOException {
            int n = 0;
            boolean bl = false;
            block102: while ((n = (int)this.mIn.getBytesRead() - this.mInitBytesRead) < this.mBlockSize || this.mBlockSize < 0) {
                int n2 = this.mIn.readUI8();
                int n3 = n2 >= 128 ? this.mIn.readUI16() : 0;
                this.applyWaitForFrameTargets();
                this.mBlock.jumpLabel(this.makeLabel(n));
                switch (n2) {
                    case 0: {
                        this.mBlock.end();
                        bl = true;
                        break block102;
                    }
                    case 129: {
                        this.mBlock.gotoFrame(this.mIn.readUI16());
                        continue block102;
                    }
                    case 131: {
                        this.mBlock.getURL(this.mIn.readString(this.mStringEncoding), this.mIn.readString(this.mStringEncoding));
                        continue block102;
                    }
                    case 4: {
                        this.mBlock.nextFrame();
                        continue block102;
                    }
                    case 5: {
                        this.mBlock.prevFrame();
                        continue block102;
                    }
                    case 6: {
                        this.mBlock.play();
                        continue block102;
                    }
                    case 7: {
                        this.mBlock.stop();
                        continue block102;
                    }
                    case 8: {
                        this.mBlock.toggleQuality();
                        continue block102;
                    }
                    case 9: {
                        this.mBlock.stopSounds();
                        continue block102;
                    }
                    case 138: {
                        this.mBlock.waitForFrame(this.mIn.readUI16(), this.newWaitForFrameTarget(this.mIn.readUI8()));
                        continue block102;
                    }
                    case 139: {
                        this.mBlock.setTarget(this.mIn.readString(this.mStringEncoding));
                        continue block102;
                    }
                    case 140: {
                        this.mBlock.gotoFrame(this.mIn.readString(this.mStringEncoding));
                        continue block102;
                    }
                    case 157: {
                        this.mBlock.ifJump(this.makeLabel(n + 5 + this.mIn.readSI16()));
                        continue block102;
                    }
                    case 153: {
                        this.mBlock.jump(this.makeLabel(n + 5 + this.mIn.readSI16()));
                        continue block102;
                    }
                    case 141: {
                        this.mBlock.waitForFrame(this.newWaitForFrameTarget(this.mIn.readUI8()));
                        continue block102;
                    }
                    case 23: {
                        this.mBlock.pop();
                        continue block102;
                    }
                    case 150: {
                        this.parsePush(n3, this.mIn);
                        continue block102;
                    }
                    case 10: {
                        this.mBlock.add();
                        continue block102;
                    }
                    case 11: {
                        this.mBlock.substract();
                        continue block102;
                    }
                    case 12: {
                        this.mBlock.multiply();
                        continue block102;
                    }
                    case 13: {
                        this.mBlock.divide();
                        continue block102;
                    }
                    case 14: {
                        this.mBlock.equals();
                        continue block102;
                    }
                    case 15: {
                        this.mBlock.lessThan();
                        continue block102;
                    }
                    case 16: {
                        this.mBlock.and();
                        continue block102;
                    }
                    case 17: {
                        this.mBlock.or();
                        continue block102;
                    }
                    case 18: {
                        this.mBlock.not();
                        continue block102;
                    }
                    case 19: {
                        this.mBlock.stringEquals();
                        continue block102;
                    }
                    case 20: {
                        this.mBlock.stringLength();
                        continue block102;
                    }
                    case 33: {
                        this.mBlock.concat();
                        continue block102;
                    }
                    case 21: {
                        this.mBlock.substring();
                        continue block102;
                    }
                    case 41: {
                        this.mBlock.stringLessThan();
                        continue block102;
                    }
                    case 53: {
                        this.mBlock.substringMB();
                        continue block102;
                    }
                    case 49: {
                        this.mBlock.stringLengthMB();
                        continue block102;
                    }
                    case 24: {
                        this.mBlock.toInteger();
                        continue block102;
                    }
                    case 50: {
                        this.mBlock.charToAscii();
                        continue block102;
                    }
                    case 51: {
                        this.mBlock.asciiToChar();
                        continue block102;
                    }
                    case 54: {
                        this.mBlock.charMBToAscii();
                        continue block102;
                    }
                    case 55: {
                        this.mBlock.asciiToCharMB();
                        continue block102;
                    }
                    case 158: {
                        this.mBlock.call();
                        continue block102;
                    }
                    case 28: {
                        this.mBlock.getVariable();
                        continue block102;
                    }
                    case 29: {
                        this.mBlock.setVariable();
                        continue block102;
                    }
                    case 154: {
                        this.parseGetURL2(this.mIn.readUI8());
                        continue block102;
                    }
                    case 159: {
                        this.mBlock.gotoFrame(this.mIn.readUI8() != 0);
                        continue block102;
                    }
                    case 32: {
                        this.mBlock.setTarget();
                        continue block102;
                    }
                    case 34: {
                        this.mBlock.getProperty();
                        continue block102;
                    }
                    case 35: {
                        this.mBlock.setProperty();
                        continue block102;
                    }
                    case 36: {
                        this.mBlock.cloneSprite();
                        continue block102;
                    }
                    case 37: {
                        this.mBlock.removeSprite();
                        continue block102;
                    }
                    case 39: {
                        this.mBlock.startDrag();
                        continue block102;
                    }
                    case 40: {
                        this.mBlock.endDrag();
                        continue block102;
                    }
                    case 38: {
                        this.mBlock.trace();
                        continue block102;
                    }
                    case 52: {
                        this.mBlock.getTime();
                        continue block102;
                    }
                    case 48: {
                        this.mBlock.randomNumber();
                        continue block102;
                    }
                    case 66: {
                        this.mBlock.initArray();
                        continue block102;
                    }
                    case 136: {
                        this.parseLookupTable(this.mIn);
                        continue block102;
                    }
                    case 61: {
                        this.mBlock.callFunction();
                        continue block102;
                    }
                    case 82: {
                        this.mBlock.callMethod();
                        continue block102;
                    }
                    case 155: {
                        this.parseDefineFunction(this.mIn);
                        continue block102;
                    }
                    case 60: {
                        this.mBlock.defineLocalValue();
                        continue block102;
                    }
                    case 65: {
                        this.mBlock.defineLocal();
                        continue block102;
                    }
                    case 58: {
                        this.mBlock.deleteProperty();
                        continue block102;
                    }
                    case 59: {
                        this.mBlock.deleteThreadVars();
                        continue block102;
                    }
                    case 70: {
                        this.mBlock.enumerate();
                        continue block102;
                    }
                    case 73: {
                        this.mBlock.typedEquals();
                        continue block102;
                    }
                    case 78: {
                        this.mBlock.getMember();
                        continue block102;
                    }
                    case 67: {
                        this.mBlock.initObject();
                        continue block102;
                    }
                    case 83: {
                        this.mBlock.newMethod();
                        continue block102;
                    }
                    case 64: {
                        this.mBlock.newObject();
                        continue block102;
                    }
                    case 79: {
                        this.mBlock.setMember();
                        continue block102;
                    }
                    case 69: {
                        this.mBlock.getTargetPath();
                        continue block102;
                    }
                    case 148: {
                        this.parseWith(this.mIn);
                        continue block102;
                    }
                    case 76: {
                        this.mBlock.duplicate();
                        continue block102;
                    }
                    case 62: {
                        this.mBlock.returnValue();
                        continue block102;
                    }
                    case 77: {
                        this.mBlock.swap();
                        continue block102;
                    }
                    case 135: {
                        this.mBlock.storeInRegister(this.mIn.readUI8());
                        continue block102;
                    }
                    case 63: {
                        this.mBlock.modulo();
                        continue block102;
                    }
                    case 68: {
                        this.mBlock.typeOf();
                        continue block102;
                    }
                    case 71: {
                        this.mBlock.typedAdd();
                        continue block102;
                    }
                    case 72: {
                        this.mBlock.typedLessThan();
                        continue block102;
                    }
                    case 74: {
                        this.mBlock.convertToNumber();
                        continue block102;
                    }
                    case 75: {
                        this.mBlock.convertToString();
                        continue block102;
                    }
                    case 80: {
                        this.mBlock.increment();
                        continue block102;
                    }
                    case 81: {
                        this.mBlock.decrement();
                        continue block102;
                    }
                    case 96: {
                        this.mBlock.bitAnd();
                        continue block102;
                    }
                    case 97: {
                        this.mBlock.bitOr();
                        continue block102;
                    }
                    case 98: {
                        this.mBlock.bitXor();
                        continue block102;
                    }
                    case 99: {
                        this.mBlock.shiftLeft();
                        continue block102;
                    }
                    case 100: {
                        this.mBlock.shiftRight();
                        continue block102;
                    }
                    case 101: {
                        this.mBlock.shiftRightUnsigned();
                        continue block102;
                    }
                    case 84: {
                        this.mBlock.instanceOf();
                        continue block102;
                    }
                    case 85: {
                        this.mBlock.enumerateObject();
                        continue block102;
                    }
                    case 103: {
                        this.mBlock.greaterThan();
                        continue block102;
                    }
                    case 102: {
                        this.mBlock.strictEquals();
                        continue block102;
                    }
                    case 104: {
                        this.mBlock.stringGreaterThan();
                        continue block102;
                    }
                    case 142: {
                        this.parseDefineFunction2(this.mIn);
                        continue block102;
                    }
                    case 42: {
                        this.mBlock._throw();
                        continue block102;
                    }
                    case 43: {
                        this.mBlock.cast();
                        continue block102;
                    }
                    case 105: {
                        this.mBlock._extends();
                        continue block102;
                    }
                    case 44: {
                        this.mBlock._implements();
                        continue block102;
                    }
                    case 143: {
                        this.parseTry(this.mIn);
                        continue block102;
                    }
                    default: {
                        this.mBlock.unknown(n2, this.mIn.read(n3));
                        continue block102;
                    }
                }
            }
            if (!bl) {
                this.applyWaitForFrameTargets();
                this.mBlock.end();
            }
        }

        private void parseTry(InStream inStream) throws IOException {
            int n = inStream.readUI8();
            int n2 = inStream.readUI16();
            int n3 = inStream.readUI16();
            int n4 = inStream.readUI16();
            String string = null;
            int n5 = -1;
            if ((n & 4) != 0) {
                n5 = inStream.readUI8();
            } else {
                string = inStream.readString(this.mStringEncoding);
            }
            SWFActionBlock.TryCatchFinally tryCatchFinally = n5 >= 0 ? this.mBlock._try(n5) : this.mBlock._try(string);
            SWFActionBlock sWFActionBlock = tryCatchFinally.tryBlock();
            BlockParser blockParser = new BlockParser(sWFActionBlock, n2, inStream, this.mFlashVersion);
            blockParser.parse();
            if ((n & 1) != 0) {
                sWFActionBlock = tryCatchFinally.catchBlock();
                blockParser = new BlockParser(sWFActionBlock, n3, inStream, this.mFlashVersion);
                blockParser.parse();
            }
            if ((n & 2) != 0) {
                sWFActionBlock = tryCatchFinally.finallyBlock();
                blockParser = new BlockParser(sWFActionBlock, n4, inStream, this.mFlashVersion);
                blockParser.parse();
            }
            tryCatchFinally.endTry();
        }

        private void parseWith(InStream inStream) throws IOException {
            int n = inStream.readUI16();
            SWFActionBlock sWFActionBlock = this.mBlock.startWith();
            BlockParser blockParser = new BlockParser(sWFActionBlock, n, inStream, this.mFlashVersion);
            blockParser.parse();
        }

        private void parseDefineFunction(InStream inStream) throws IOException {
            int n;
            String string = inStream.readString(this.mStringEncoding);
            int n2 = inStream.readUI16();
            String[] stringArray = new String[n2];
            for (n = 0; n < stringArray.length; ++n) {
                stringArray[n] = inStream.readString(this.mStringEncoding);
            }
            n = inStream.readUI16();
            SWFActionBlock sWFActionBlock = this.mBlock.startFunction(string, stringArray);
            BlockParser blockParser = new BlockParser(sWFActionBlock, n, inStream, this.mFlashVersion);
            blockParser.parse();
        }

        private void parseDefineFunction2(InStream inStream) throws IOException {
            int n;
            String string = inStream.readString(this.mStringEncoding);
            int n2 = inStream.readUI16();
            int n3 = inStream.readUI8();
            int n4 = inStream.readUI16();
            String[] stringArray = new String[n2];
            int[] nArray = new int[n2];
            for (n = 0; n < stringArray.length; ++n) {
                nArray[n] = inStream.readUI8();
                stringArray[n] = inStream.readString(this.mStringEncoding);
            }
            n = inStream.readUI16();
            SWFActionBlock sWFActionBlock = this.mBlock.startFunction2(string, n3, n4, stringArray, nArray);
            BlockParser blockParser = new BlockParser(sWFActionBlock, n, inStream, this.mFlashVersion);
            blockParser.parse();
        }

        private void parseLookupTable(InStream inStream) throws IOException {
            String[] stringArray = new String[inStream.readUI16()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = inStream.readString(this.mStringEncoding);
            }
            this.mBlock.lookupTable(stringArray);
        }

        private void parseGetURL2(int n) throws IOException {
            int n2 = n & 3;
            int n3 = 0;
            switch (n & 0xF0) {
                case 64: {
                    n3 = 1;
                    break;
                }
                case 128: {
                    n3 = 3;
                    break;
                }
                case 192: {
                    n3 = 4;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            this.mBlock.getURL(n2, n3);
        }

        private void parsePush(int n, InStream inStream) throws IOException {
            int n2 = (int)inStream.getBytesRead();
            while (inStream.getBytesRead() - (long)n2 < (long)n) {
                int n3 = inStream.readUI8();
                switch (n3) {
                    case 0: {
                        this.mBlock.push(inStream.readString(this.mStringEncoding));
                        break;
                    }
                    case 1: {
                        this.mBlock.push(inStream.readFloat());
                        break;
                    }
                    case 2: {
                        this.mBlock.pushNull();
                        break;
                    }
                    case 3: {
                        this.mBlock.pushUndefined();
                        break;
                    }
                    case 4: {
                        this.mBlock.pushRegister(inStream.readUI8());
                        break;
                    }
                    case 5: {
                        this.mBlock.push(inStream.readUI8() != 0);
                        break;
                    }
                    case 6: {
                        this.mBlock.push(inStream.readDouble());
                        break;
                    }
                    case 7: {
                        this.mBlock.push(inStream.readSI32());
                        break;
                    }
                    case 8: {
                        this.mBlock.lookup(inStream.readUI8());
                        break;
                    }
                    case 9: {
                        this.mBlock.lookup(inStream.readUI16());
                        break;
                    }
                }
            }
        }
    }

    private static class WaitForFrameTarget {
        public int actionsToSkip;
        public String targetLabel;

        public WaitForFrameTarget(int n, String string) {
            this.actionsToSkip = n;
            this.targetLabel = string;
        }
    }
}

