/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFText;
import com.anotherbigidea.flash.interfaces.SWFVectors;
import com.anotherbigidea.flash.movie.Actions;
import com.anotherbigidea.flash.movie.Button;
import com.anotherbigidea.flash.movie.EditField;
import com.anotherbigidea.flash.movie.Font;
import com.anotherbigidea.flash.movie.FontDefinition;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.Image;
import com.anotherbigidea.flash.movie.Instance;
import com.anotherbigidea.flash.movie.MorphShape;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.MovieClip;
import com.anotherbigidea.flash.movie.QTMovie;
import com.anotherbigidea.flash.movie.Shape;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.Text;
import com.anotherbigidea.flash.movie.TimeLine;
import com.anotherbigidea.flash.movie.Transform;
import com.anotherbigidea.flash.structs.AlphaColor;
import com.anotherbigidea.flash.structs.AlphaTransform;
import com.anotherbigidea.flash.structs.ButtonRecord;
import com.anotherbigidea.flash.structs.ButtonRecord2;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.ColorTransform;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.structs.SoundInfo;
import com.anotherbigidea.flash.writers.SWFActionsImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class MovieBuilder
implements SWFTagTypes {
    protected Movie movie;
    protected MovieClip clip;
    protected boolean newMovie = false;
    protected Frame frame;
    protected Map symbols = new HashMap();
    protected TimeLine timeline;
    protected Map instances = new HashMap();

    public MovieBuilder() {
        this.movie = new Movie();
        this.newMovie = true;
        this.timeline = this.movie;
    }

    public MovieBuilder(Movie movie) {
        this.movie = movie;
        this.newMovie = false;
        this.timeline = movie;
    }

    protected MovieBuilder(MovieBuilder movieBuilder, MovieClip movieClip) {
        this.movie = movieBuilder.movie;
        this.symbols = movieBuilder.symbols;
        this.clip = movieClip;
        this.newMovie = false;
        this.timeline = movieClip;
    }

    public Movie getMovie() {
        return this.movie;
    }

    public Map getDefinedSymbols() {
        return this.symbols;
    }

    protected Symbol getSymbol(int n) {
        return (Symbol)this.symbols.get(new Integer(n));
    }

    protected void saveSymbol(int n, Symbol symbol) {
        this.symbols.put(new Integer(n), symbol);
    }

    protected Instance getInstance(int n) {
        return (Instance)this.instances.get(new Integer(n));
    }

    protected void saveInstance(int n, Instance instance) {
        if (instance == null) {
            try {
                throw new Exception();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.instances.put(new Integer(n), instance);
    }

    public void tag(int n, boolean bl, byte[] byArray) throws IOException {
    }

    public void header(int n, long l, int n2, int n3, int n4, int n5) throws IOException {
        if (this.newMovie) {
            this.movie.setVersion(n);
            this.movie.setWidth(n2 / 20);
            this.movie.setHeight(n3 / 20);
            this.movie.setFrameRate(n4);
        }
    }

    public void tagEnd() throws IOException {
    }

    public void tagShowFrame() throws IOException {
        if (this.frame == null) {
            this.timeline.appendFrame();
        } else {
            this.frame = null;
        }
    }

    protected Frame currentFrame() {
        if (this.frame == null) {
            this.frame = this.timeline.appendFrame();
        }
        return this.frame;
    }

    public void tagDefineSound(int n, int n2, int n3, boolean bl, boolean bl2, int n4, byte[] byArray) throws IOException {
    }

    public void tagDefineButtonSound(int n, int n2, SoundInfo soundInfo, int n3, SoundInfo soundInfo2, int n4, SoundInfo soundInfo3, int n5, SoundInfo soundInfo4) throws IOException {
    }

    public void tagStartSound(int n, SoundInfo soundInfo) throws IOException {
    }

    public void tagSoundStreamHead(int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
    }

    public void tagSoundStreamHead2(int n, boolean bl, boolean bl2, int n2, int n3, boolean bl3, boolean bl4, int n4) throws IOException {
    }

    public void tagSoundStreamBlock(byte[] byArray) throws IOException {
    }

    public void tagSerialNumber(String string) throws IOException {
    }

    public void tagGenerator(byte[] byArray) throws IOException {
    }

    public void tagGeneratorText(byte[] byArray) throws IOException {
    }

    public void tagGeneratorCommand(byte[] byArray) throws IOException {
    }

    public void tagGeneratorFont(byte[] byArray) throws IOException {
    }

    public void tagNameCharacter(byte[] byArray) throws IOException {
    }

    public void tagDefineBits(int n, byte[] byArray) throws IOException {
    }

    public void tagJPEGTables(byte[] byArray) throws IOException {
    }

    public void tagDefineBitsJPEG3(int n, byte[] byArray, byte[] byArray2) throws IOException {
    }

    public SWFActions tagDoInitAction(int n) throws IOException {
        return null;
    }

    public SWFActions tagDoAction() throws IOException {
        Actions actions = this.currentFrame().actions(this.movie.getVersion());
        return actions;
    }

    public SWFShape tagDefineShape(int n, Rect rect) throws IOException {
        Shape shape = new Shape();
        shape.setBoundingRectangle((double)rect.getMinX() / 20.0, (double)rect.getMinY() / 20.0, (double)rect.getMaxX() / 20.0, (double)rect.getMaxY() / 20.0);
        this.saveSymbol(n, shape);
        return new ShapeBuilder(shape);
    }

    public SWFShape tagDefineShape2(int n, Rect rect) throws IOException {
        Shape shape = new Shape();
        shape.setBoundingRectangle((double)rect.getMinX() / 20.0, (double)rect.getMinY() / 20.0, (double)rect.getMaxX() / 20.0, (double)rect.getMaxY() / 20.0);
        this.saveSymbol(n, shape);
        return new ShapeBuilder(shape);
    }

    public SWFShape tagDefineShape3(int n, Rect rect) throws IOException {
        Shape shape = new Shape();
        shape.setBoundingRectangle((double)rect.getMinX() / 20.0, (double)rect.getMinY() / 20.0, (double)rect.getMaxX() / 20.0, (double)rect.getMaxY() / 20.0);
        this.saveSymbol(n, shape);
        return new ShapeBuilder(shape);
    }

    public void tagFreeCharacter(int n) throws IOException {
    }

    public void tagPlaceObject(int n, int n2, Matrix matrix, AlphaTransform alphaTransform) throws IOException {
        Symbol symbol = this.getSymbol(n);
        if (symbol == null) {
            return;
        }
        this.timeline.setAvailableDepth(n2);
        Instance instance = this.currentFrame().placeSymbol(symbol, matrix != null ? new Transform(matrix) : null, alphaTransform);
        this.saveInstance(n2, instance);
    }

    public SWFActions tagPlaceObject2(boolean bl, int n, int n2, int n3, Matrix matrix, AlphaTransform alphaTransform, int n4, String string, int n5) throws IOException {
        Instance instance = null;
        if (n2 == 59) {
            // empty if block
        }
        if (bl && n3 <= 0) {
            instance = this.getInstance(n2);
            if (instance == null) {
                System.out.println("Failed to find Instance at depth " + n2);
                return null;
            }
            this.currentFrame().alter(instance, matrix != null ? new Transform(matrix) : null, alphaTransform, n4);
        } else {
            Symbol symbol = this.getSymbol(n3);
            if (n2 == 59) {
                // empty if block
            }
            if (symbol == null) {
                System.out.println("Failed to find Symbol with id " + n3);
                return null;
            }
            if (string != null) {
                Frame frame = this.currentFrame();
                if (bl) {
                    instance = frame.replaceMovieClip(symbol, n2, matrix != null ? new Transform(matrix) : null, alphaTransform, string, null);
                } else {
                    this.timeline.setAvailableDepth(n2);
                    instance = frame.placeMovieClip(symbol, matrix != null ? new Transform(matrix) : null, alphaTransform, string, null);
                }
                this.saveInstance(n2, instance);
            } else {
                if (n5 != 0) {
                    return new ClipActionBuilder(symbol, matrix, alphaTransform, n2, string, this.movie.getVersion(), bl);
                }
                Frame frame = this.currentFrame();
                if (bl) {
                    instance = frame.replaceSymbol(symbol, n2, matrix != null ? new Transform(matrix) : null, alphaTransform, n4, n);
                } else {
                    this.timeline.setAvailableDepth(n2);
                    instance = frame.placeSymbol(symbol, matrix != null ? new Transform(matrix) : null, alphaTransform, n4, n);
                }
                this.saveInstance(n2, instance);
            }
        }
        return null;
    }

    public void tagRemoveObject(int n, int n2) throws IOException {
        Instance instance = this.getInstance(n2);
        if (instance == null) {
            return;
        }
        this.currentFrame().remove(instance);
    }

    public void tagRemoveObject2(int n) throws IOException {
        Instance instance = this.getInstance(n);
        if (instance == null) {
            return;
        }
        this.currentFrame().remove(instance);
    }

    public void tagSetBackgroundColor(Color color) throws IOException {
        if (this.newMovie) {
            this.movie.setBackColor(color);
        }
    }

    public void tagFrameLabel(String string) throws IOException {
        this.tagFrameLabel(string, false);
    }

    public void tagFrameLabel(String string, boolean bl) throws IOException {
        this.currentFrame().setLabel(string);
        this.currentFrame().setAnchor(bl);
    }

    public SWFTagTypes tagDefineSprite(int n) throws IOException {
        MovieClip movieClip = new MovieClip();
        this.saveSymbol(n, movieClip);
        return new MovieBuilder(this, movieClip);
    }

    public void tagProtect(byte[] byArray) throws IOException {
        if (this.newMovie) {
            this.movie.protect(true);
        }
    }

    public void tagEnableDebug(byte[] byArray) throws IOException {
    }

    public void tagEnableDebug2(byte[] byArray) throws IOException {
    }

    public SWFVectors tagDefineFont(int n, int n2) throws IOException {
        FontDefinition fontDefinition = new FontDefinition();
        Font font = new Font(fontDefinition);
        this.saveSymbol(n, font);
        return new GlyphBuilder(fontDefinition, font, n2);
    }

    public void tagDefineFontInfo(int n, String string, int n2, int[] nArray) {
        this.defineFontInfo(n, string, n2, nArray, 0);
    }

    public void defineFontInfo(int n, String string, int n2, int[] nArray, int n3) {
        Symbol symbol = this.getSymbol(n);
        if (symbol == null || !(symbol instanceof Font)) {
            return;
        }
        Font font = (Font)symbol;
        FontDefinition fontDefinition = font.getDefinition();
        fontDefinition.setName(string);
        boolean bl = (n2 & 0x20) != 0;
        boolean bl2 = (n2 & 0x10) != 0;
        boolean bl3 = (n2 & 8) != 0;
        boolean bl4 = (n2 & 4) != 0;
        boolean bl5 = (n2 & 2) != 0;
        fontDefinition.setFontFlags(bl, bl2, bl3, bl4, bl5, false);
        List list = font.getGlyphList();
        int n4 = list.size();
        for (int i = 0; i < nArray.length && i < n4; ++i) {
            int n5 = nArray[i];
            font.setCode(i, n5);
        }
        font.setLanguageCode(n3);
    }

    public void tagDefineFontInfo2(int n, String string, int n2, int[] nArray, int n3) {
        this.defineFontInfo(n, string, n2, nArray, n3);
    }

    public SWFVectors tagDefineFont2(int n, int n2, String string, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2, Rect[] rectArray, int[] nArray3, int[] nArray4, int[] nArray5) throws IOException {
        boolean bl = (n2 & 0x80) != 0;
        boolean bl2 = (n2 & 0x40) != 0;
        boolean bl3 = (n2 & 0x20) != 0;
        boolean bl4 = (n2 & 0x10) != 0;
        boolean bl5 = (n2 & 2) != 0;
        boolean bl6 = (n2 & 1) != 0;
        FontDefinition fontDefinition = new FontDefinition(string, (double)n4 / 20.0, (double)n5 / 20.0, (double)n6 / 20.0, bl3, bl2, bl4, bl5, bl6, bl);
        Font font = new Font(fontDefinition);
        this.saveSymbol(n, font);
        if (bl && nArray3 != null) {
            ArrayList arrayList = fontDefinition.getKerningPairList();
            for (int i = 0; i < nArray3.length; ++i) {
                FontDefinition.KerningPair kerningPair = new FontDefinition.KerningPair(nArray3[i], nArray4[i], (double)nArray5[i] / 20.0);
                arrayList.add(kerningPair);
            }
        }
        return new GlyphBuilder(fontDefinition, font, nArray, nArray2, rectArray);
    }

    public void tagDefineTextField(int n, String string, String string2, Rect rect, int n2, AlphaColor alphaColor, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) throws IOException {
        Symbol symbol = this.getSymbol(n4);
        if (symbol == null || !(symbol instanceof Font)) {
            return;
        }
        Font font = (Font)symbol;
        EditField editField = new EditField(string, string2, font, (double)n5 / 20.0, (double)rect.getMinX() / 20.0, (double)rect.getMinY() / 20.0, (double)rect.getMaxX() / 20.0, (double)rect.getMaxY() / 20.0);
        editField.setTextColor(alphaColor);
        editField.setAlignment(n3);
        editField.setCharLimit(n6);
        editField.setLeftMargin((double)n7 / 20.0);
        editField.setRightMargin((double)n8 / 20.0);
        editField.setIndentation((double)n9 / 20.0);
        editField.setLineSpacing((double)n10 / 20.0);
        boolean bl = (n2 & 0x1000) == 0;
        boolean bl2 = (n2 & 0x800) != 0;
        boolean bl3 = (n2 & 0x200) != 0;
        boolean bl4 = (n2 & 0x100) == 0;
        boolean bl5 = (n2 & 0x40) != 0;
        boolean bl6 = (n2 & 0x20) != 0;
        boolean bl7 = (n2 & 0x10) != 0;
        boolean bl8 = (n2 & 8) == 0;
        editField.setProperties(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8);
        this.saveSymbol(n, editField);
    }

    public SWFText tagDefineText(int n, Rect rect, Matrix matrix) throws IOException {
        Text text = new Text(new Transform(matrix));
        this.saveSymbol(n, text);
        return new TextBuilder(text);
    }

    public SWFText tagDefineText2(int n, Rect rect, Matrix matrix) throws IOException {
        Text text = new Text(new Transform(matrix));
        this.saveSymbol(n, text);
        return new TextBuilder(text);
    }

    public SWFActions tagDefineButton(int n, Vector vector) throws IOException {
        Button button = new Button(false);
        this.saveSymbol(n, button);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ButtonRecord buttonRecord = (ButtonRecord)enumeration.nextElement();
            Symbol symbol = this.getSymbol(buttonRecord.getCharId());
            if (symbol == null) continue;
            int n2 = buttonRecord.getFlags();
            boolean bl = (n2 & 8) != 0;
            boolean bl2 = (n2 & 1) != 0;
            boolean bl3 = (n2 & 2) != 0;
            boolean bl4 = (n2 & 4) != 0;
            button.addLayer(symbol, new Transform(buttonRecord.getMatrix()), null, buttonRecord.getLayer(), bl, bl2, bl4, bl3);
        }
        return new ButtonActionBuilder(button, this.movie.getVersion());
    }

    public void tagButtonCXForm(int n, ColorTransform colorTransform) throws IOException {
        Symbol symbol = this.getSymbol(n);
        if (symbol == null || !(symbol instanceof Button)) {
            return;
        }
        Button button = (Button)symbol;
        ArrayList arrayList = button.getButtonLayers();
        for (Button.Layer layer : arrayList) {
            layer.setColoring(new AlphaTransform(colorTransform));
        }
    }

    public SWFActions tagDefineButton2(int n, boolean bl, Vector vector) throws IOException {
        Button button = new Button(bl);
        this.saveSymbol(n, button);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ButtonRecord2 buttonRecord2 = (ButtonRecord2)enumeration.nextElement();
            Symbol symbol = this.getSymbol(buttonRecord2.getCharId());
            if (symbol == null) continue;
            int n2 = buttonRecord2.getFlags();
            boolean bl2 = (n2 & 8) != 0;
            boolean bl3 = (n2 & 1) != 0;
            boolean bl4 = (n2 & 2) != 0;
            boolean bl5 = (n2 & 4) != 0;
            button.addLayer(symbol, new Transform(buttonRecord2.getMatrix()), buttonRecord2.getTransform(), buttonRecord2.getLayer(), bl2, bl3, bl5, bl4);
        }
        return new ButtonActionBuilder(button, this.movie.getVersion());
    }

    public void tagExport(String[] stringArray, int[] nArray) throws IOException {
        Symbol[] symbolArray = new Symbol[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            symbolArray[i] = this.getSymbol(nArray[i]);
        }
        this.movie.exportSymbols(stringArray, symbolArray);
    }

    public void tagImport(String string, String[] stringArray, int[] nArray) throws IOException {
        this.movie.importSymbols(string, stringArray);
    }

    public void tagDefineQuickTimeMovie(int n, String string) throws IOException {
        this.saveSymbol(n, new QTMovie(string));
    }

    public void tagDefineBitsJPEG2(int n, byte[] byArray) throws IOException {
        this.saveSymbol(n, new Image.JPEG(byArray));
    }

    public void tagDefineBitsJPEG2(int n, InputStream inputStream) throws IOException {
        this.saveSymbol(n, new Image.JPEG(inputStream));
    }

    public void tagDefineBitsLossless(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        this.saveSymbol(n, new Image.Lossless(colorArray, byArray, (double)n3 / 20.0, (double)n4 / 20.0, false, n2));
    }

    public void tagDefineBitsLossless2(int n, int n2, int n3, int n4, Color[] colorArray, byte[] byArray) throws IOException {
        this.saveSymbol(n, new Image.Lossless(colorArray, byArray, (double)n3 / 20.0, (double)n4 / 20.0, true, n2));
    }

    public SWFShape tagDefineMorphShape(int n, Rect rect, Rect rect2) throws IOException {
        return new MorphShapeBuilder(n, rect, rect2);
    }

    public void tagScriptLimits(int n, int n2) throws IOException {
    }

    public void tagTabOrder(int n, int n2) throws IOException {
    }

    public void tagDefineVideoStream(int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
    }

    public void tagVideoFrame(int n, int n2, int n3, int n4, byte[] byArray) throws IOException {
    }

    protected class TextBuilder
    implements SWFText {
        protected Text t;
        protected Font font;
        protected double size;
        protected Color color;
        protected double x;
        protected double y;
        protected boolean hasX;
        protected boolean hasY;

        protected TextBuilder(Text text) {
            this.t = text;
        }

        public void font(int n, int n2) {
            Symbol symbol = MovieBuilder.this.getSymbol(n);
            if (symbol == null || !(symbol instanceof Font)) {
                return;
            }
            this.font = (Font)symbol;
            this.size = (double)n2 / 20.0;
        }

        public void color(Color color) {
            this.color = color;
        }

        public void setX(int n) {
            this.hasX = true;
            this.x = (double)n / 20.0;
        }

        public void setY(int n) {
            this.hasY = true;
            this.y = (double)n / 20.0;
        }

        public void text(int[] nArray, int[] nArray2) {
            List list = this.font.getGlyphList();
            char[] cArray = new char[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                double d = (double)nArray2[i] / 20.0;
                d = d * 51.2 / this.size;
                FontDefinition.Glyph glyph = (FontDefinition.Glyph)list.get(n);
                cArray[i] = (char)glyph.getCode();
                if (!(d > glyph.getAdvance())) continue;
                glyph.setAdvance(d);
            }
            try {
                Font.Chars chars = this.font.chars(new String(cArray), this.size);
                this.t.row(chars, this.color, this.x, this.y, this.hasX, this.hasY);
            }
            catch (Font.NoGlyphException noGlyphException) {
                // empty catch block
            }
            this.color = null;
            this.hasX = false;
            this.hasY = false;
        }

        public void done() {
        }
    }

    protected class GlyphBuilder
    extends ShapeBuilder {
        protected FontDefinition fontDef;
        protected Font font;
        protected int count;
        protected int[] advances;
        protected int[] codes;
        protected Rect[] bounds;
        protected List defGlyphs;
        protected List fontGlyphs;
        protected int index;

        public GlyphBuilder(FontDefinition fontDefinition, Font font, int n) {
            super(new Shape());
            this.index = 0;
            this.fontDef = fontDefinition;
            this.font = font;
            this.count = n;
            this.defGlyphs = fontDefinition.getGlyphList();
            this.fontGlyphs = font.getGlyphList();
        }

        public GlyphBuilder(FontDefinition fontDefinition, Font font, int[] nArray, int[] nArray2, Rect[] rectArray) {
            this(fontDefinition, font, nArray.length);
            this.codes = nArray;
            this.advances = nArray2;
            this.bounds = rectArray;
        }

        public void done() {
            if (this.index >= this.count) {
                return;
            }
            if (this.bounds != null) {
                Rect rect = this.bounds[this.index];
                this.s.setBoundingRectangle((double)rect.getMinX() / 20.0, (double)rect.getMinY() / 20.0, (double)rect.getMaxX() / 20.0, (double)rect.getMaxY() / 20.0);
            }
            double d = this.advances != null ? (double)this.advances[this.index] / 20.0 : 0.0;
            int n = this.codes != null ? this.codes[this.index] : 0;
            FontDefinition.Glyph glyph = new FontDefinition.Glyph(this.s, d, n);
            this.defGlyphs.add(glyph);
            this.font.addGlyph(glyph);
            ++this.index;
            if (this.index < this.count) {
                this.s = new Shape();
            }
        }
    }

    protected class MorphShapeBuilder
    extends ShapeBuilder {
        protected int id;
        protected Rect startBounds;
        protected Rect endBounds;
        protected Shape shape1;

        protected MorphShapeBuilder(int n, Rect rect, Rect rect2) {
            super(new Shape());
            this.id = n;
            this.startBounds = rect;
            this.endBounds = rect2;
        }

        public void done() {
            if (this.shape1 == null) {
                this.shape1 = this.s;
                this.s = new Shape();
                return;
            }
            Shape shape = this.s;
            MorphShape morphShape = new MorphShape(this.shape1, shape);
            MovieBuilder.this.saveSymbol(this.id, morphShape);
        }
    }

    protected class ShapeBuilder
    implements SWFShape {
        protected Shape s;
        protected int currx;
        protected int curry;

        protected ShapeBuilder(Shape shape) {
            this.s = shape;
        }

        public void done() {
        }

        public void line(int n, int n2) {
            this.currx += n;
            this.curry += n2;
            this.s.line((double)this.currx / 20.0, (double)this.curry / 20.0);
        }

        public void curve(int n, int n2, int n3, int n4) {
            this.currx = (n += this.currx) + n3;
            this.curry = (n2 += this.curry) + n4;
            this.s.curve((double)this.currx / 20.0, (double)this.curry / 20.0, (double)n / 20.0, (double)n2 / 20.0);
        }

        public void move(int n, int n2) {
            this.currx = n;
            this.curry = n2;
            this.s.move((double)this.currx / 20.0, (double)this.curry / 20.0);
        }

        public void setFillStyle0(int n) {
            this.s.setLeftFillStyle(n);
        }

        public void setFillStyle1(int n) {
            this.s.setRightFillStyle(n);
        }

        public void setLineStyle(int n) {
            this.s.setLineStyle(n);
        }

        public void defineFillStyle(Color color) {
            this.s.defineFillStyle(color);
        }

        public void defineFillStyle(Matrix matrix, int[] nArray, Color[] colorArray, boolean bl) {
            this.s.defineFillStyle(colorArray, nArray, new Transform(matrix), bl);
        }

        public void defineFillStyle(int n, Matrix matrix, boolean bl) {
            Symbol symbol = MovieBuilder.this.getSymbol(n);
            this.s.defineFillStyle(symbol, new Transform(matrix), bl);
        }

        public void defineLineStyle(int n, Color color) {
            this.s.defineLineStyle((double)n / 20.0, color);
        }
    }

    protected class ClipActionBuilder
    extends ActionsBuilder {
        protected Symbol symbol;
        protected Transform matrix;
        protected AlphaTransform cxform;
        protected String name;
        protected int depth;
        protected boolean isMove;

        protected ClipActionBuilder(Symbol symbol, Matrix matrix, AlphaTransform alphaTransform, int n, String string, int n2, boolean bl) {
            super(n2);
            this.symbol = symbol;
            this.matrix = matrix != null ? new Transform(matrix) : null;
            this.cxform = alphaTransform;
            this.name = string;
            this.depth = n;
            this.isMove = bl;
        }

        public void done() throws IOException {
            Frame frame = MovieBuilder.this.currentFrame();
            Instance instance = null;
            if (this.isMove) {
                frame.replaceMovieClip(this.symbol, this.depth, this.matrix, this.cxform, this.name, this.getActions());
            } else {
                MovieBuilder.this.timeline.setAvailableDepth(this.depth);
                frame.placeMovieClip(this.symbol, this.matrix, this.cxform, this.name, this.getActions());
            }
            MovieBuilder.this.saveInstance(this.depth, instance);
        }
    }

    protected class ButtonActionBuilder
    extends ActionsBuilder {
        protected Button but;

        protected ButtonActionBuilder(Button button, int n) {
            super(n);
            this.but = button;
        }

        public SWFActionBlock start(int n) throws IOException {
            if (n == 0) {
                n = 8;
            }
            this.acts = this.but.addActions(n, this.version);
            return this.acts.start(n);
        }
    }

    protected static class ActionsBuilder
    extends SWFActionsImpl {
        protected int version;
        protected Vector actions = new Vector();

        protected ActionsBuilder(int n) {
            super(null);
            this.version = n;
        }

        public Actions[] getActions() {
            Object[] objectArray = new Actions[this.actions.size()];
            this.actions.copyInto(objectArray);
            return objectArray;
        }

        public SWFActionBlock start(int n) throws IOException {
            this.acts = new Actions(n, this.version);
            this.actions.addElement(this.acts);
            return this.acts.start(n);
        }
    }
}

