/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.readers;

import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.io.InStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SWFReader {
    protected SWFTags mConsumer;
    protected InStream mIn;
    protected InputStream mInputstream;
    protected boolean mCompressed;
    protected String mFilename;
    public boolean ignoreProblemTags = false;
    public boolean copeWithUnexpectedEOF = false;

    public SWFReader(SWFTags sWFTags, String string) throws IOException {
        this(sWFTags, new FileInputStream(string));
        this.mFilename = string;
    }

    public SWFReader(SWFTags sWFTags, InputStream inputStream) {
        this.mConsumer = sWFTags;
        this.mInputstream = inputStream;
        this.mIn = new InStream(inputStream);
    }

    public SWFReader(SWFTags sWFTags, InStream inStream) {
        this.mConsumer = sWFTags;
        this.mIn = inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile() throws IOException {
        try {
            this.readHeader();
            this.readTags();
        }
        finally {
            if (this.mFilename != null) {
                this.mInputstream.close();
            }
        }
    }

    public void readTags() throws IOException {
        while (this.readOneTag() != 0) {
        }
    }

    public int readOneTag() throws IOException {
        boolean bl = false;
        try {
            boolean bl2;
            int n = this.mIn.readUI16();
            int n2 = n >> 6;
            int n3 = n & 0x3F;
            boolean bl3 = bl2 = n3 == 63;
            if (bl2) {
                n3 = (int)this.mIn.readUI32();
            }
            byte[] byArray = this.mIn.read(n3);
            try {
                this.mConsumer.tag(n2, bl2, byArray);
            }
            catch (IOException iOException) {
                if (this.ignoreProblemTags) {
                    return -1;
                }
                bl = true;
                throw iOException;
            }
            return n2;
        }
        catch (IOException iOException) {
            if (this.copeWithUnexpectedEOF && !bl) {
                this.mConsumer.tag(0, false, new byte[0]);
                return 0;
            }
            throw iOException;
        }
    }

    public void readSignature() throws IOException {
        int[] nArray = new int[]{this.mIn.readUI8(), this.mIn.readUI8(), this.mIn.readUI8()};
        if (nArray[0] != 70 && nArray[0] != 67 || nArray[1] != 87 || nArray[2] != 83) {
            throw new IOException("Invalid SWF File Signature");
        }
        boolean bl = this.mCompressed = nArray[0] == 67;
        if (this.mConsumer instanceof SWFFileSignature) {
            ((SWFFileSignature)((Object)this.mConsumer)).signature(this.mCompressed ? "CWS" : "FWS");
        }
    }

    public void readHeader() throws IOException {
        this.readSignature();
        this.readRemainderOfHeader();
    }

    public void readRemainderOfHeader() throws IOException {
        int n = this.mIn.readUI8();
        long l = this.mIn.readUI32();
        if (this.mCompressed) {
            this.mIn.readCompressed();
        }
        Rect rect = new Rect(this.mIn);
        int n2 = this.mIn.readUI16() >> 8;
        int n3 = this.mIn.readUI16();
        this.mConsumer.header(n, l, rect.getMaxX(), rect.getMaxY(), n2, n3);
    }

    public static void main(String[] stringArray) throws IOException {
        SWFWriter sWFWriter = new SWFWriter(stringArray[1]);
        if (stringArray.length > 2) {
            if (stringArray[2].equals("+")) {
                sWFWriter.setCompression(true);
            } else if (stringArray[2].equals("-")) {
                sWFWriter.setCompression(false);
            }
        }
        SWFReader sWFReader = new SWFReader((SWFTags)sWFWriter, stringArray[0]);
        sWFReader.readFile();
    }
}

