/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.sound.ADPCMConstants;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class ADPCMEncodeStream
implements ADPCMConstants {
    protected InputStream samplesIn;
    protected boolean is16bit;
    protected boolean isDone = false;
    protected boolean isSigned;
    protected ArrayList sampleStack = new ArrayList();
    protected int valpred = 0;
    protected int index = 0;

    public ADPCMEncodeStream(InputStream inputStream, boolean bl, boolean bl2) {
        this.samplesIn = inputStream;
        this.is16bit = bl;
        this.isSigned = bl2;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getIndex() {
        return this.index;
    }

    public int getDelta() throws IOException {
        int n;
        int n2 = this.getSample();
        int n3 = stepsizeTable[this.index];
        int n4 = n2 - this.valpred;
        int n5 = n = n4 < 0 ? 8 : 0;
        if (n > 0) {
            n4 = -n4;
        }
        int n6 = 0;
        int n7 = n3 >> 3;
        if (n4 >= n3) {
            n6 = 4;
            n4 -= n3;
            n7 += n3;
        }
        if (n4 >= (n3 >>= 1)) {
            n6 |= 2;
            n4 -= n3;
            n7 += n3;
        }
        if (n4 >= (n3 >>= 1)) {
            n6 |= 1;
            n7 += n3;
        }
        this.valpred = n > 0 ? (this.valpred -= n7) : (this.valpred += n7);
        if (this.valpred > Short.MAX_VALUE) {
            this.valpred = Short.MAX_VALUE;
        } else if (this.valpred < Short.MIN_VALUE) {
            this.valpred = Short.MIN_VALUE;
        }
        this.index += indexTable[n6 |= n];
        if (this.index < 0) {
            this.index = 0;
        }
        if (this.index > 88) {
            this.index = 88;
        }
        return n6;
    }

    public int getSample() throws IOException {
        if (!this.sampleStack.isEmpty()) {
            Integer n = (Integer)this.sampleStack.remove(this.sampleStack.size() - 1);
            return n;
        }
        int n = this.read();
        if (!this.is16bit) {
            return (n -= 128) * 256;
        }
        int n2 = this.read();
        n2 <<= 8;
        if (this.isSigned && (n2 += n) > Short.MAX_VALUE) {
            n2 -= 65536;
        }
        return n2;
    }

    protected int read() throws IOException {
        int n = this.samplesIn.read();
        if (n < 0) {
            this.isDone = true;
            n = 0;
        }
        return n;
    }

    public void pushSample(int n) {
        this.sampleStack.add(new Integer(n));
    }

    public int getFirstPacketSample() throws IOException {
        int n;
        this.valpred = n = this.getSample();
        return n;
    }

    public int peekSample() throws IOException {
        int n = this.getSample();
        this.pushSample(n);
        return n;
    }

    public int setIndex(int n) throws IOException {
        int n2;
        int n3;
        int n4 = this.peekSample();
        int n5 = n4 - n;
        if (n5 < 0) {
            n5 = -n5;
        }
        for (n3 = 0; n3 < ADPCMConstants.stepsizeTable.length && ((n2 = ADPCMConstants.stepsizeTable[n3]) <= n5 || n3 <= 0); ++n3) {
        }
        this.index = n3 - 1;
        return this.index;
    }
}

