/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.sound;

import com.anotherbigidea.flash.sound.ADPCMHelper;
import com.anotherbigidea.flash.sound.SoundDefinition;
import com.anotherbigidea.flash.sound.SoundStreamHead;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class RawHelper {
    public static SoundStreamHead streamingBlocks(InputStream inputStream, int n, ArrayList arrayList) throws IOException, UnsupportedAudioFileException {
        int n2;
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(inputStream);
        AudioFormat audioFormat = audioInputStream.getFormat();
        int n3 = audioFormat.getFrameSize();
        boolean bl = audioFormat.getChannels() == 2;
        boolean bl2 = audioFormat.getSampleSizeInBits() > 8;
        int n4 = (int)audioFormat.getSampleRate();
        int n5 = 0;
        if ((n4 = n4 >= 44000 ? 44000 : (n4 >= 22000 ? 22000 : (n4 >= 11000 ? 11000 : 5500))) == 44000) {
            n5 = 3;
        } else if (n4 == 22000) {
            n5 = 2;
        } else if (n4 == 11000) {
            n5 = 1;
        }
        int n6 = n4 / n;
        int n7 = n6 * (bl2 ? 2 : 1) * (bl ? 2 : 1);
        SoundStreamHead soundStreamHead = new SoundStreamHead(n5, bl2, bl, 0, n5, bl2, bl, n6);
        if (arrayList == null) {
            return soundStreamHead;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n7 + 1000);
        do {
            int n8;
            byteArrayOutputStream.reset();
            byte[] byArray = new byte[n3];
            n2 = 0;
            for (n8 = 0; n8 < n7; n8 += n2) {
                n2 = 0;
                while ((n2 = audioInputStream.read(byArray, n2, n3 - n2)) < n3 && n2 != -1) {
                }
                if (n2 == -1) break;
                byteArrayOutputStream.write(byArray);
            }
            while (n8 < n7) {
                byteArrayOutputStream.write(128);
                ++n8;
            }
            arrayList.add(byteArrayOutputStream.toByteArray());
        } while (n2 != -1);
        return soundStreamHead;
    }

    public static SoundDefinition getSoundDefinition(InputStream inputStream, int n) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(inputStream));
        AudioFormat audioFormat = audioInputStream.getFormat();
        int n2 = audioFormat.getFrameSize();
        boolean bl = audioFormat.getChannels() == 2;
        boolean bl2 = audioFormat.getSampleSizeInBits() > 8;
        int n3 = (int)audioFormat.getSampleRate();
        int n4 = 0;
        if ((n3 = n3 >= 44000 ? 44000 : (n3 >= 22000 ? 22000 : (n3 >= 11000 ? 11000 : 5500))) == 44000) {
            n4 = 3;
        } else if (n3 == 22000) {
            n4 = 2;
        } else if (n3 == 11000) {
            n4 = 1;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ADPCMHelper.FramedInputStream framedInputStream = new ADPCMHelper.FramedInputStream(audioInputStream, n2);
        int n5 = 0;
        int n6 = 0;
        while ((n5 = framedInputStream.read()) >= 0) {
            ++n6;
            byteArrayOutputStream.write(n5);
        }
        int n7 = n6;
        if (bl2) {
            n7 /= 2;
        }
        if (bl) {
            n7 /= 2;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return new SoundDefinition(0, n4, bl2, bl, n7, byArray);
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
        SWFWriter sWFWriter = new SWFWriter(stringArray[1]);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        tagWriter.header(5, -1L, 200, 200, 12, -1);
        tagWriter.tagSetBackgroundColor(new Color(255, 255, 255));
        ArrayList arrayList = new ArrayList();
        SoundStreamHead soundStreamHead = RawHelper.streamingBlocks(bufferedInputStream, 12, arrayList);
        ((InputStream)bufferedInputStream).close();
        soundStreamHead.write(tagWriter);
        for (byte[] byArray : arrayList) {
            tagWriter.tagSoundStreamBlock(byArray);
            tagWriter.tagShowFrame();
        }
        tagWriter.tagEnd();
    }
}

