/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class Matrix {
    protected double scaleX = 1.0;
    protected double scaleY = 1.0;
    protected double skew0 = 0.0;
    protected double skew1 = 0.0;
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public double getSkew0() {
        return this.skew0;
    }

    public double getSkew1() {
        return this.skew1;
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setScaleX(double d) {
        this.scaleX = d;
    }

    public void setScaleY(double d) {
        this.scaleY = d;
    }

    public void setSkew0(double d) {
        this.skew0 = d;
    }

    public void setSkew1(double d) {
        this.skew1 = d;
    }

    public void setTranslateX(double d) {
        this.translateX = d;
    }

    public void setTranslateY(double d) {
        this.translateY = d;
    }

    public Matrix() {
        this(1.0, 1.0, 0.0, 0.0, 0.0, 0.0);
    }

    public Matrix(double d, double d2) {
        this(1.0, 1.0, 0.0, 0.0, d, d2);
    }

    public Matrix(Matrix matrix) {
        if (matrix == null) {
            return;
        }
        this.scaleX = matrix.scaleX;
        this.scaleY = matrix.scaleY;
        this.skew0 = matrix.skew0;
        this.skew1 = matrix.skew1;
        this.translateX = matrix.translateX;
        this.translateY = matrix.translateY;
    }

    public Matrix(double d, double d2, double d3, double d4, double d5, double d6) {
        this.scaleX = d;
        this.scaleY = d2;
        this.skew0 = d3;
        this.skew1 = d4;
        this.setTranslateX(d5);
        this.setTranslateY(d6);
    }

    public Matrix(InStream inStream) throws IOException {
        int n;
        inStream.synchBits();
        if (inStream.readUBits(1) == 1L) {
            n = (int)inStream.readUBits(5);
            this.scaleX = (double)inStream.readSBits(n) / 65536.0;
            this.scaleY = (double)inStream.readSBits(n) / 65536.0;
        }
        if (inStream.readUBits(1) == 1L) {
            n = (int)inStream.readUBits(5);
            this.skew0 = (double)inStream.readSBits(n) / 65536.0;
            this.skew1 = (double)inStream.readSBits(n) / 65536.0;
        }
        n = (int)inStream.readUBits(5);
        this.translateX = inStream.readSBits(n);
        this.translateY = inStream.readSBits(n);
    }

    public void write(OutStream outStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        outStream.flushBits();
        if (this.scaleX != 1.0 || this.scaleY != 1.0) {
            n4 = (int)(this.scaleX * 65536.0);
            n3 = (int)(this.scaleY * 65536.0);
            n2 = OutStream.determineSignedBitSize(n4);
            n = OutStream.determineSignedBitSize(n3);
            if (n2 < n) {
                n2 = n;
            }
            outStream.writeUBits(1, 1L);
            outStream.writeUBits(5, n2);
            outStream.writeSBits(n2, n4);
            outStream.writeSBits(n2, n3);
        } else {
            outStream.writeUBits(1, 0L);
        }
        if (this.skew0 != 0.0 || this.skew1 != 0.0) {
            n4 = (int)(this.skew0 * 65536.0);
            n3 = (int)(this.skew1 * 65536.0);
            n2 = OutStream.determineSignedBitSize(n4);
            n = OutStream.determineSignedBitSize(n3);
            if (n2 < n) {
                n2 = n;
            }
            outStream.writeUBits(1, 1L);
            outStream.writeUBits(5, n2);
            outStream.writeSBits(n2, n4);
            outStream.writeSBits(n2, n3);
        } else {
            outStream.writeUBits(1, 0L);
        }
        if (this.translateX == 0.0 && this.translateY == 0.0) {
            outStream.writeUBits(5, 0L);
        } else {
            n4 = OutStream.determineSignedBitSize((int)this.translateX);
            n3 = OutStream.determineSignedBitSize((int)this.translateY);
            if (n4 < n3) {
                n4 = n3;
            }
            outStream.writeUBits(5, n4);
            outStream.writeSBits(n4, (int)this.translateX);
            outStream.writeSBits(n4, (int)this.translateY);
        }
        outStream.flushBits();
    }

    public String toString() {
        return " Matrix(sx,sy,s0,s1,tx,ty)=(" + this.scaleX + "," + this.scaleY + "," + this.skew0 + "," + this.skew1 + "," + this.translateX + "," + this.translateY + ")";
    }
}

