/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.SWFActionCodes;
import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import java.io.IOException;
import java.io.PrintWriter;

public class ActionTextWriter
implements SWFActions,
SWFActionBlock,
SWFActionCodes {
    protected PrintWriter printer;
    protected int blockLevel = 0;
    protected String indent = "";
    protected String label = null;
    public static final String LABEL_ZONE = "      ";

    public ActionTextWriter(PrintWriter printWriter) {
        this.printer = printWriter;
    }

    public void indent() {
        this.indent = this.indent + "    ";
    }

    public void unindent() {
        this.indent = this.indent.length() < 4 ? "" : this.indent.substring(0, this.indent.length() - 4);
    }

    protected void print(String string, String[] stringArray) {
        this.printer.print("  ");
        if (this.label != null) {
            this.printer.print(this.label + ":" + (this.label.length() < 5 ? LABEL_ZONE.substring(this.label.length() + 1) : " "));
            this.label = null;
        } else {
            this.printer.print(LABEL_ZONE);
        }
        this.printer.print(this.indent);
        if (string.equals("{") || string.equals("}") || string.startsWith("catch") || string.startsWith("finally")) {
            this.printer.println(string);
            return;
        }
        this.writePaddedString(string + " ", 15);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    this.printer.print(", ");
                }
                this.printer.print(stringArray[i]);
            }
        }
        this.printer.println();
    }

    protected void writePaddedString(String string, int n) {
        this.printer.print(string);
        for (int i = n - string.length(); i > 0; --i) {
            this.printer.print(" ");
        }
    }

    public SWFActionBlock start(int n) throws IOException {
        this.print("conditions", new String[]{Integer.toBinaryString(n)});
        this.printer.flush();
        return this;
    }

    public SWFActionBlock start(int n, int n2) throws IOException {
        this.print("conditions", new String[]{Integer.toBinaryString(n), "keycode = " + n2});
        this.printer.flush();
        return this;
    }

    public void done() throws IOException {
        this.printer.flush();
    }

    public void end() throws IOException {
        if (this.blockLevel > 0) {
            this.unindent();
            this.print("}", null);
            --this.blockLevel;
        } else {
            this.print("end", null);
        }
    }

    public void blob(byte[] byArray) throws IOException {
        this.print("(blob)", null);
        this.printer.println();
    }

    public void unknown(int n, byte[] byArray) throws IOException {
        this.print("unknown code =", new String[]{Integer.toString(n)});
    }

    public void initArray() throws IOException {
        this.print("initArray", null);
    }

    public void jumpLabel(String string) throws IOException {
        if (this.label != null) {
            this.print("", null);
        }
        this.label = string;
    }

    public void gotoFrame(int n) throws IOException {
        this.print("gotoFrame", new String[]{Integer.toString(n)});
    }

    public void gotoFrame(String string) throws IOException {
        this.print("gotoFrame", new String[]{"\"" + string + "\""});
    }

    public void getURL(String string, String string2) throws IOException {
        this.print("getURL", new String[]{"\"" + string + "\"", "\"" + string2 + "\""});
    }

    public void nextFrame() throws IOException {
        this.print("nextFrame", null);
    }

    public void prevFrame() throws IOException {
        this.print("previousFrame", null);
    }

    public void play() throws IOException {
        this.print("play", null);
    }

    public void stop() throws IOException {
        this.print("stop", null);
    }

    public void toggleQuality() throws IOException {
        this.print("toggleQuality", null);
    }

    public void stopSounds() throws IOException {
        this.print("stopSounds", null);
    }

    public void setTarget(String string) throws IOException {
        this.print("setTarget", new String[]{"\"" + string + "\""});
    }

    public void jump(String string) throws IOException {
        this.print("jump", new String[]{"\"" + string + "\""});
    }

    public void ifJump(String string) throws IOException {
        this.print("ifJump", new String[]{"\"" + string + "\""});
    }

    public void waitForFrame(int n, String string) throws IOException {
        this.print("waitForFrame", new String[]{Integer.toString(n), "\"" + string + "\""});
    }

    public void waitForFrame(String string) throws IOException {
        this.print("waitForFrame", new String[]{"\"" + string + "\""});
    }

    public void pop() throws IOException {
        this.print("pop", null);
    }

    public void push(String string) throws IOException {
        this.print("push", new String[]{"\"" + string + "\""});
    }

    public void push(float f) throws IOException {
        this.print("push", new String[]{"float " + f});
    }

    public void push(double d) throws IOException {
        this.print("push", new String[]{"double " + d});
    }

    public void pushNull() throws IOException {
        this.print("push", new String[]{"null"});
    }

    public void pushUndefined() throws IOException {
        this.print("push", new String[]{"undefined"});
    }

    public void pushRegister(int n) throws IOException {
        this.print("push", new String[]{"register( " + n + " )"});
    }

    public void push(boolean bl) throws IOException {
        this.print("push", new String[]{bl ? "true" : "false"});
    }

    public void push(int n) throws IOException {
        this.print("push", new String[]{"" + n});
    }

    public void lookup(int n) throws IOException {
        this.print("push", new String[]{"lookup( " + n + " )"});
    }

    public void add() throws IOException {
        this.print("add", null);
    }

    public void substract() throws IOException {
        this.print("substract", null);
    }

    public void multiply() throws IOException {
        this.print("multiply", null);
    }

    public void divide() throws IOException {
        this.print("divide", null);
    }

    public void equals() throws IOException {
        this.print("equals", null);
    }

    public void lessThan() throws IOException {
        this.print("lessThan", null);
    }

    public void and() throws IOException {
        this.print("and", null);
    }

    public void or() throws IOException {
        this.print("or", null);
    }

    public void not() throws IOException {
        this.print("not", null);
    }

    public void stringEquals() throws IOException {
        this.print("stringEquals", null);
    }

    public void stringLength() throws IOException {
        this.print("stringLength", null);
    }

    public void concat() throws IOException {
        this.print("concat", null);
    }

    public void substring() throws IOException {
        this.print("substring", null);
    }

    public void stringLessThan() throws IOException {
        this.print("stringLessThan", null);
    }

    public void stringLengthMB() throws IOException {
        this.print("stringLengthMB", null);
    }

    public void substringMB() throws IOException {
        this.print("substringMB", null);
    }

    public void toInteger() throws IOException {
        this.print("toInteger", null);
    }

    public void charToAscii() throws IOException {
        this.print("charToAscii", null);
    }

    public void asciiToChar() throws IOException {
        this.print("asciiToChar", null);
    }

    public void charMBToAscii() throws IOException {
        this.print("charMBToAscii", null);
    }

    public void asciiToCharMB() throws IOException {
        this.print("asciiToCharMB", null);
    }

    public void call() throws IOException {
        this.print("call", null);
    }

    public void getVariable() throws IOException {
        this.print("getVariable", null);
    }

    public void setVariable() throws IOException {
        this.print("setVariable", null);
    }

    public void getURL(int n, int n2) throws IOException {
        String string = null;
        switch (n) {
            case 1: {
                string = "send vars via GET";
                break;
            }
            case 2: {
                string = "send vars via POST";
                break;
            }
            default: {
                string = "no send";
            }
        }
        String string2 = null;
        switch (n2) {
            case 0: {
                string2 = "load movie into level";
                break;
            }
            case 1: {
                string2 = "load movie into sprite";
                break;
            }
            case 3: {
                string2 = "load vars into level";
                break;
            }
            case 4: {
                string2 = "load vars into sprite";
                break;
            }
            default: {
                string2 = "???";
            }
        }
        this.print("getURL", new String[]{string, string2});
    }

    public void gotoFrame(boolean bl) throws IOException {
        this.print("gotoFrame", new String[]{bl ? "and play" : "and stop"});
    }

    public void setTarget() throws IOException {
        this.print("setTarget", null);
    }

    public void getProperty() throws IOException {
        this.print("getProperty", null);
    }

    public void setProperty() throws IOException {
        this.print("setProperty", null);
    }

    public void cloneSprite() throws IOException {
        this.print("cloneSprite", null);
    }

    public void removeSprite() throws IOException {
        this.print("removeSprite", null);
    }

    public void startDrag() throws IOException {
        this.print("startDrag", null);
    }

    public void endDrag() throws IOException {
        this.print("endDrag", null);
    }

    public void trace() throws IOException {
        this.print("trace", null);
    }

    public void getTime() throws IOException {
        this.print("getTime", null);
    }

    public void randomNumber() throws IOException {
        this.print("randomNumber", null);
    }

    public void lookupTable(String[] stringArray) throws IOException {
        this.print("lookupTable", null);
        for (int i = 0; i < stringArray.length; ++i) {
            this.printer.print(this.indent + "        ");
            this.writePaddedString(Integer.toString(i) + ":", 5);
            this.printer.println("\"" + stringArray[i] + "\"");
        }
    }

    public void callFunction() throws IOException {
        this.print("callFunction", null);
    }

    public void callMethod() throws IOException {
        this.print("callMethod", null);
    }

    public SWFActionBlock startFunction(String string, String[] stringArray) throws IOException {
        String string2 = string + "(";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + " " + stringArray[i];
            }
            if (stringArray.length > 0) {
                string2 = string2 + " ";
            }
        }
        string2 = string2 + ")";
        this.printer.println();
        this.print("defineFunction", new String[]{string2});
        this.print("{", null);
        this.indent();
        ++this.blockLevel;
        return this;
    }

    public SWFActionBlock startFunction2(String string, int n, int n2, String[] stringArray, int[] nArray) throws IOException {
        int n3;
        String string2 = string + "(";
        if (stringArray != null) {
            for (n3 = 0; n3 < stringArray.length; ++n3) {
                if (n3 > 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + " " + stringArray[n3];
                if (nArray[n3] == 0) continue;
                string2 = string2 + " [reg " + nArray[n3] + "]";
            }
            if (stringArray.length > 0) {
                string2 = string2 + " ";
            }
        }
        string2 = string2 + ") num registers = ";
        string2 = string2 + n;
        this.printer.println();
        this.print("defineFunction", new String[]{string2});
        n3 = 1;
        if ((n2 & 1) != 0) {
            this.print("    Preload this      [reg " + n3++ + "]", null);
        }
        if ((n2 & 4) != 0) {
            this.print("    Preload arguments [reg " + n3++ + "]", null);
        }
        if ((n2 & 0x10) != 0) {
            this.print("    Preload super     [reg " + n3++ + "]", null);
        }
        if ((n2 & 0x40) != 0) {
            this.print("    Preload root      [reg " + n3++ + "]", null);
        }
        if ((n2 & 0x80) != 0) {
            this.print("    Preload parent    [reg " + n3++ + "]", null);
        }
        if ((n2 & 0x100) != 0) {
            this.print("    Preload global    [reg " + n3++ + "]", null);
        }
        if ((n2 & 0x20) != 0) {
            this.print("    Supress super", null);
        }
        if ((n2 & 8) != 0) {
            this.print("    Supress arguments", null);
        }
        if ((n2 & 2) != 0) {
            this.print("    Supress this", null);
        }
        this.print("{", null);
        this.indent();
        ++this.blockLevel;
        return this;
    }

    public void comment(String string) throws IOException {
        this.printer.println(this.indent + "    // " + string);
    }

    public void defineLocalValue() throws IOException {
        this.print("defineLocalValue", null);
    }

    public void defineLocal() throws IOException {
        this.print("defineLocal", null);
    }

    public void deleteProperty() throws IOException {
        this.print("deleteProperty", null);
    }

    public void deleteThreadVars() throws IOException {
        this.print("deleteThreadVars", null);
    }

    public void enumerate() throws IOException {
        this.print("enumerate", null);
    }

    public void typedEquals() throws IOException {
        this.print("typedEquals", null);
    }

    public void getMember() throws IOException {
        this.print("getMember", null);
    }

    public void initObject() throws IOException {
        this.print("initObject", null);
    }

    public void newMethod() throws IOException {
        this.print("newMethod", null);
    }

    public void newObject() throws IOException {
        this.print("newObject", null);
    }

    public void setMember() throws IOException {
        this.print("setMember", null);
    }

    public void getTargetPath() throws IOException {
        this.print("getTargetPath", null);
    }

    public SWFActionBlock startWith() throws IOException {
        this.printer.println();
        this.print("with", null);
        this.print("{", null);
        this.indent();
        ++this.blockLevel;
        return this;
    }

    public void duplicate() throws IOException {
        this.print("duplicate", null);
    }

    public void returnValue() throws IOException {
        this.print("return", null);
    }

    public void swap() throws IOException {
        this.print("swap", null);
    }

    public void storeInRegister(int n) throws IOException {
        this.print("register", new String[]{Integer.toString(n)});
    }

    public void convertToNumber() throws IOException {
        this.print("convertToNumber", null);
    }

    public void convertToString() throws IOException {
        this.print("convertToString", null);
    }

    public void typeOf() throws IOException {
        this.print("typeOf", null);
    }

    public void typedAdd() throws IOException {
        this.print("typedAdd", null);
    }

    public void typedLessThan() throws IOException {
        this.print("typedLessThan", null);
    }

    public void modulo() throws IOException {
        this.print("modulo", null);
    }

    public void bitAnd() throws IOException {
        this.print("bitAnd", null);
    }

    public void bitOr() throws IOException {
        this.print("bitOr", null);
    }

    public void bitXor() throws IOException {
        this.print("bitXor", null);
    }

    public void shiftLeft() throws IOException {
        this.print("shiftLeft", null);
    }

    public void shiftRight() throws IOException {
        this.print("shiftRight", null);
    }

    public void shiftRightUnsigned() throws IOException {
        this.print("shiftRightUnsigned", null);
    }

    public void decrement() throws IOException {
        this.print("decrement", null);
    }

    public void increment() throws IOException {
        this.print("increment", null);
    }

    public void enumerateObject() throws IOException {
        this.print("enumerateObject", null);
    }

    public void greaterThan() throws IOException {
        this.print("greaterThan", null);
    }

    public void instanceOf() throws IOException {
        this.print("instanceOf", null);
    }

    public void strictEquals() throws IOException {
        this.print("strictEquals", null);
    }

    public void stringGreaterThan() throws IOException {
        this.print("greaterThan", null);
    }

    public void _extends() throws IOException {
        this.print("extends", null);
    }

    public void _implements() throws IOException {
        this.print("implements", null);
    }

    public void _throw() throws IOException {
        this.print("throw", null);
    }

    public void cast() throws IOException {
        this.print("cast", null);
    }

    public SWFActionBlock.TryCatchFinally _try(String string) throws IOException {
        return new TryImpl(string);
    }

    public SWFActionBlock.TryCatchFinally _try(int n) throws IOException {
        return new TryImpl("register " + n);
    }

    private class TryImpl
    implements SWFActionBlock.TryCatchFinally {
        private String mCatchName;

        TryImpl(String string) {
            this.mCatchName = string;
        }

        public SWFActionBlock catchBlock() throws IOException {
            ActionTextWriter.this.print("catch( " + this.mCatchName + " ) {", null);
            ActionTextWriter.this.indent();
            ++ActionTextWriter.this.blockLevel;
            return ActionTextWriter.this;
        }

        public void endTry() throws IOException {
        }

        public SWFActionBlock finallyBlock() throws IOException {
            ActionTextWriter.this.print("finally {", null);
            ActionTextWriter.this.indent();
            ++ActionTextWriter.this.blockLevel;
            return ActionTextWriter.this;
        }

        public SWFActionBlock tryBlock() throws IOException {
            ActionTextWriter.this.print("try {", null);
            ActionTextWriter.this.indent();
            ++ActionTextWriter.this.blockLevel;
            return ActionTextWriter.this;
        }
    }
}

