/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.writers;

import com.anotherbigidea.flash.interfaces.SWFFileSignature;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.io.OutStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SWFWriter
implements SWFTags,
SWFFileSignature {
    protected OutStream mOut;
    protected OutputStream mOutputstream;
    protected ByteArrayOutputStream mByteout;
    protected String mSignature = null;
    protected boolean recalculateLengthAndCount = false;
    protected int frameCount;
    protected int version;
    protected Rect frameSize;
    protected int height;
    protected int rate;

    public SWFWriter(String string) throws IOException {
        this(new FileOutputStream(string));
    }

    public SWFWriter(OutputStream outputStream) {
        this.mOutputstream = outputStream;
        this.mOut = new OutStream(outputStream);
    }

    public SWFWriter(OutStream outStream) {
        this.mOut = outStream;
    }

    public void recalculateLengthAndCount() {
        this.recalculateLengthAndCount = true;
    }

    public void signature(String string) {
        if (this.mSignature != null) {
            return;
        }
        this.mSignature = string;
    }

    public void setCompression(boolean bl) {
        this.signature(bl ? "CWS" : "FWS");
    }

    public void header(int n, long l, int n2, int n3, int n4, int n5) throws IOException {
        this.frameSize = new Rect(0, 0, n2, n3);
        if (this.recalculateLengthAndCount) {
            l = -1L;
            n5 = -1;
        }
        if (l < 0L || n5 < 0) {
            this.version = n;
            this.rate = n4;
            this.frameCount = 0;
            if (this.mByteout == null) {
                this.mByteout = new ByteArrayOutputStream(20000);
                this.mOut = new OutStream(this.mByteout);
            }
            return;
        }
        this.writeHeader(n, l, n4, n5);
    }

    public void tag(int n, boolean bl, byte[] byArray) throws IOException {
        int n2 = byArray != null ? byArray.length : 0;
        bl = n2 > 62 || bl;
        int n3 = (n << 6) + (bl ? 63 : n2);
        this.mOut.writeUI16(n3);
        if (bl) {
            this.mOut.writeUI32(n2);
        }
        if (byArray != null) {
            this.mOut.write(byArray);
        }
        if (n == 1) {
            ++this.frameCount;
        }
        if (n == 0) {
            this.finish();
        }
    }

    protected void writeHeader(int n, long l, int n2, int n3) throws IOException {
        this.writeSignature();
        this.mOut.writeUI8(n);
        this.mOut.writeUI32(l);
        if (this.mSignature.equals("CWS")) {
            this.mOut.writeCompressed();
        }
        this.frameSize.write(this.mOut);
        this.mOut.writeUI16(n2 << 8);
        this.mOut.writeUI16(n3);
    }

    private void writeSignature() throws IOException {
        if (this.mSignature == null) {
            this.signature("FWS");
        }
        this.mOut.write(this.mSignature.getBytes("US-ASCII"));
    }

    protected void finish() throws IOException {
        if (this.mByteout != null) {
            byte[] byArray = this.mByteout.toByteArray();
            long l = 12L + this.frameSize.getLength() + (long)byArray.length;
            this.mOut = new OutStream(this.mOutputstream);
            this.writeHeader(this.version, l, this.rate, this.frameCount);
            this.mOut.write(byArray);
        }
        this.mOut.close();
        this.mOut = null;
    }

    public void close() {
        if (this.mOutputstream != null) {
            try {
                this.mOutputstream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mOut != null) {
            try {
                this.mOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

