/*
 * Decompiled with CFR 0.152.
 */
package org.epistem.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Hashtable;

public class Base64 {
    public static final char[] charset = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    public static final char paddingChar = '=';
    protected static Hashtable charLookup = new Hashtable();

    public static void decode(Reader reader, OutputStream outputStream) throws Exception {
        char[] cArray = new char[4];
        int[] nArray = new int[4];
        while (true) {
            int n;
            int n2 = 0;
            while (n2 < 4 && (n = reader.read()) >= 0) {
                char c = (char)n;
                if (Character.isWhitespace(c)) continue;
                cArray[n2++] = c;
            }
            if (n2 == 0) {
                return;
            }
            if (n2 != 4) {
                throw new Exception("Incomplete character quartet at end of Base64 input");
            }
            for (n = 0; n < 4; ++n) {
                Integer n3 = (Integer)charLookup.get(new Character(cArray[n]));
                if (n3 == null) {
                    if (cArray[n] != '=' || n < 2) {
                        throw new Exception("Invalid char (" + cArray[n] + ") in Base64 data");
                    }
                    nArray[n] = -1;
                    continue;
                }
                nArray[n] = n3;
            }
            outputStream.write((nArray[0] << 2) + (nArray[1] >> 4));
            n = (nArray[1] & 0xF) << 4;
            if (nArray[2] < 0) continue;
            outputStream.write(n += nArray[2] >> 2);
            n = (nArray[2] & 3) << 6;
            if (nArray[3] < 0) continue;
            outputStream.write(n += nArray[3]);
        }
    }

    public static byte[] decode(String string) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringReader stringReader = new StringReader(string);
        Base64.decode(stringReader, byteArrayOutputStream);
        stringReader.close();
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void encode(InputStream inputStream, Writer writer) throws IOException {
        int n = 0;
        while (true) {
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            if (n2 < 0) {
                return;
            }
            if (n >= 72) {
                n = 0;
                writer.write(10);
            }
            writer.write(charset[n2 >> 2]);
            int n5 = (n2 & 3) << 4;
            if (n3 < 0) {
                writer.write(charset[n5]);
                writer.write(61);
                writer.write(61);
                return;
            }
            writer.write(charset[n5 += n3 >> 4]);
            n5 = (n3 & 0xF) << 2;
            if (n4 < 0) {
                writer.write(charset[n5]);
                writer.write(61);
                return;
            }
            writer.write(charset[n5 += n4 >> 6]);
            writer.write(charset[n4 & 0x3F]);
            n += 4;
        }
    }

    public static String encode(byte[] byArray) {
        try {
            return Base64.encode(byArray, 0, byArray.length);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return arrayIndexOutOfBoundsException.toString();
        }
    }

    public static String encode(byte[] byArray, int n, int n2) throws ArrayIndexOutOfBoundsException {
        StringWriter stringWriter = new StringWriter();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        try {
            Base64.encode(byteArrayInputStream, stringWriter);
            byteArrayInputStream.close();
            stringWriter.flush();
            stringWriter.close();
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(System.out);
            Base64.encode(System.in, outputStreamWriter);
            outputStreamWriter.flush();
            return;
        }
        Base64.decode(new InputStreamReader(System.in), System.out);
        System.out.flush();
    }

    static {
        for (int i = 0; i < charset.length; ++i) {
            charLookup.put(new Character(charset[i]), new Integer(i));
        }
    }
}

