/*
 * Decompiled with CFR 0.152.
 */
package org.javaswf.tools.screenshot;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import javax.imageio.ImageIO;

public class ScreenshotSaver {
    private File dirToSaveTo;
    private String filenamePrefix;
    private int imageIndex = 1;
    private static Timer timer;

    public ScreenshotSaver(File file, String string) {
        this.dirToSaveTo = file;
        this.filenamePrefix = string;
    }

    public boolean saveScreenShot() throws IOException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (!transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
            return false;
        }
        try {
            BufferedImage bufferedImage = (BufferedImage)transferable.getTransferData(DataFlavor.imageFlavor);
            String string = Integer.toString(this.imageIndex++);
            while (string.length() < 5) {
                string = "0" + string;
            }
            File file = new File(this.dirToSaveTo, "screenshot_" + string + ".png");
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
            StringSelection stringSelection = new StringSelection("image was saved as " + file);
            clipboard.setContents(stringSelection, null);
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws IOException {
        File file = new File(stringArray[0]);
        file.mkdirs();
        ScreenshotSaver screenshotSaver = new ScreenshotSaver(file, "screenshot");
        try {
            while (true) {
                Thread.sleep(1000L);
                screenshotSaver.saveScreenShot();
            }
        }
        catch (InterruptedException interruptedException) {
            System.exit(0);
            return;
        }
    }
}

