/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.BrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.DestroyableRuntimeExecutingBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.Firefox2Launcher;
import org.openqa.selenium.server.browserlaunchers.Firefox3Launcher;
import org.openqa.selenium.server.browserlaunchers.FirefoxChromeLauncher;
import org.openqa.selenium.server.browserlaunchers.FirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.HTABrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.InternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.KonquerorLauncher;
import org.openqa.selenium.server.browserlaunchers.MockBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.OperaCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionFirefoxCustomProfileLauncher;
import org.openqa.selenium.server.browserlaunchers.ProxyInjectionInternetExplorerCustomProxyLauncher;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserLauncherFactory {
    private static Log LOGGER = LogFactory.getLog(BrowserLauncherFactory.class);
    private static final Pattern CUSTOM_PATTERN = Pattern.compile("^\\*custom( .*)?$");
    private static final Map<String, Class<? extends BrowserLauncher>> supportedBrowsers = new HashMap<String, Class<? extends BrowserLauncher>>();

    public BrowserLauncher getBrowserLauncher(String browser, String sessionId, RemoteControlConfiguration configuration) {
        if (browser == null) {
            throw new IllegalArgumentException("browser may not be null");
        }
        for (Map.Entry<String, Class<? extends BrowserLauncher>> entry : supportedBrowsers.entrySet()) {
            Pattern pattern = Pattern.compile("^\\*" + entry.getKey() + "( .*)?$");
            Matcher matcher = pattern.matcher(browser);
            if (!matcher.find()) continue;
            String browserStartCommand = browser.equals("*" + entry.getKey()) ? null : matcher.group(1).substring(1);
            LOGGER.debug("Requested browser string '" + browser + "' matches *" + entry + " ");
            return this.createBrowserLauncher(entry.getValue(), browserStartCommand, sessionId, configuration);
        }
        LOGGER.debug("Requested browser string '" + browser + "' does not match any known browser, treating is as a custom browser...");
        Matcher CustomMatcher = CUSTOM_PATTERN.matcher(browser);
        if (CustomMatcher.find()) {
            String browserStartCommand = CustomMatcher.group(1);
            if (browserStartCommand == null) {
                throw new RuntimeException("You must specify the path to an executable when using *custom!\n\n");
            }
            browserStartCommand = browserStartCommand.substring(1);
            return new DestroyableRuntimeExecutingBrowserLauncher(browserStartCommand, sessionId);
        }
        throw this.browserNotSupported(browser);
    }

    public static Map<String, Class<? extends BrowserLauncher>> getSupportedLaunchers() {
        return supportedBrowsers;
    }

    public static void addBrowserLauncher(String browser, Class<? extends BrowserLauncher> clazz) {
        supportedBrowsers.put(browser, clazz);
    }

    private RuntimeException browserNotSupported(String browser) {
        StringBuffer errorMessage = new StringBuffer("Browser not supported: " + browser);
        errorMessage.append('\n');
        if (!browser.startsWith("*")) {
            errorMessage.append("(Did you forget to add a *?)\n");
        }
        errorMessage.append('\n');
        errorMessage.append("Supported browsers include:\n");
        for (String name : supportedBrowsers.keySet()) {
            errorMessage.append("  *").append(name).append('\n');
        }
        errorMessage.append("  *custom\n");
        return new RuntimeException(errorMessage.toString());
    }

    private BrowserLauncher createBrowserLauncher(Class<? extends BrowserLauncher> c, String browserStartCommand, String sessionId, RemoteControlConfiguration configuration) {
        try {
            try {
                BrowserLauncher browserLauncher;
                if (null == browserStartCommand) {
                    Constructor<? extends BrowserLauncher> ctor = c.getConstructor(RemoteControlConfiguration.class, String.class);
                    browserLauncher = ctor.newInstance(configuration, sessionId);
                } else {
                    Constructor<? extends BrowserLauncher> ctor = c.getConstructor(RemoteControlConfiguration.class, String.class, String.class);
                    browserLauncher = ctor.newInstance(configuration, sessionId, browserStartCommand);
                }
                return browserLauncher;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static {
        supportedBrowsers.put("firefox", FirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("chrome", FirefoxChromeLauncher.class);
        supportedBrowsers.put("firefox2", Firefox2Launcher.class);
        supportedBrowsers.put("firefox3", Firefox3Launcher.class);
        supportedBrowsers.put("iexplore", InternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("safari", SafariCustomProfileLauncher.class);
        supportedBrowsers.put("iehta", HTABrowserLauncher.class);
        supportedBrowsers.put("opera", OperaCustomProfileLauncher.class);
        supportedBrowsers.put("piiexplore", ProxyInjectionInternetExplorerCustomProxyLauncher.class);
        supportedBrowsers.put("pifirefox", ProxyInjectionFirefoxCustomProfileLauncher.class);
        supportedBrowsers.put("konqueror", KonquerorLauncher.class);
        supportedBrowsers.put("mock", MockBrowserLauncher.class);
    }
}

