/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.ApplicationRegistry;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.AbstractBrowserLauncher;
import org.openqa.selenium.server.browserlaunchers.AsyncExecute;
import org.openqa.selenium.server.browserlaunchers.BrowserInstallation;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.locators.Firefox2or3Locator;

public class FirefoxChromeLauncher
extends AbstractBrowserLauncher {
    public static final String CHROME_URL = "chrome://killff/content/kill.html";
    private static Log LOGGER = LogFactory.getLog(FirefoxChromeLauncher.class);
    private static boolean simple = false;
    private File customProfileDir;
    private String[] cmdarray;
    private boolean closed = false;
    private BrowserInstallation browserInstallation;
    private Process process;
    private static AsyncExecute shell = new AsyncExecute();
    private static boolean changeMaxConnections = false;

    public FirefoxChromeLauncher(RemoteControlConfiguration configuration, String sessionId) {
        this(configuration, sessionId, (String)null);
    }

    public FirefoxChromeLauncher(RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        this(configuration, sessionId, ApplicationRegistry.instance().browserInstallationCache().locateBrowserInstallation("firefox", browserLaunchLocation, new Firefox2or3Locator()));
    }

    public FirefoxChromeLauncher(RemoteControlConfiguration configuration, String sessionId, BrowserInstallation browserInstallation) {
        super(sessionId, configuration);
        this.browserInstallation = browserInstallation;
        shell.setLibraryPath(browserInstallation.libraryPath());
        shell.setEnvironmentVariable("MOZ_NO_REMOTE", "1");
    }

    protected void launch(String url) {
        try {
            String homePage = new ChromeUrlConvert().convert(url, this.getPort());
            String profilePath = this.makeCustomProfile(homePage);
            this.populateCustomProfileDirectory(profilePath);
            LOGGER.info("Launching Firefox...");
            this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", profilePath};
            shell.setCommandline(this.cmdarray);
            this.process = shell.asyncSpawn();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void populateCustomProfileDirectory(String profilePath) throws IOException {
        this.cmdarray = new String[]{this.browserInstallation.launcherFilePath(), "-profile", profilePath, "-chrome", CHROME_URL};
        LOGGER.info("Preparing Firefox profile...");
        shell.setCommandline(this.cmdarray);
        shell.execute();
        this.waitForFullProfileToBeCreated(20000L);
    }

    private String makeCustomProfile(String homePage) throws IOException {
        this.customProfileDir = LauncherUtils.createCustomProfileDir(this.sessionId);
        if (simple) {
            return this.customProfileDir.getAbsolutePath();
        }
        String sourceLocationName = "/customProfileDirCUSTFFCHROME";
        File firefoxProfileTemplate = this.getConfiguration().getFirefoxProfileTemplate();
        if (firefoxProfileTemplate != null) {
            LauncherUtils.copyDirectory(firefoxProfileTemplate, this.customProfileDir);
        }
        ResourceExtractor.extractResourcePath(this.getClass(), sourceLocationName, this.customProfileDir);
        this.copyRunnerHtmlFiles();
        LauncherUtils.generatePacAndPrefJs(this.customProfileDir, this.getPort(), LauncherUtils.ProxySetting.NO_PROXY, homePage, changeMaxConnections, this.getConfiguration());
        return this.customProfileDir.getAbsolutePath();
    }

    private void copyRunnerHtmlFiles() {
        String guid = "{503A0CD4-EDC8-489b-853B-19E0BAA8F0A4}";
        File extensionDir = new File(this.customProfileDir, "extensions/" + guid);
        File htmlDir = new File(extensionDir, "chrome");
        htmlDir.mkdirs();
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/TestRunner.html", "TestRunner.html");
        LauncherUtils.extractHTAFile(htmlDir, this.getPort(), "/core/RemoteRunner.html", "RemoteRunner.html");
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.process == null) {
            return;
        }
        LOGGER.info("Killing Firefox...");
        Throwable taskKillException = null;
        FileLockRemainedException fileLockException = null;
        int exitValue = AsyncExecute.killProcess(this.process);
        if (exitValue == 0) {
            LOGGER.warn("Firefox seems to have ended on its own (did we kill the real browser???)");
        }
        try {
            this.waitForFileLockToGoAway(0L, 500L);
        }
        catch (FileLockRemainedException e1) {
            fileLockException = e1;
        }
        try {
            LauncherUtils.deleteTryTryAgain(this.customProfileDir, 6);
        }
        catch (RuntimeException e) {
            if (taskKillException != null || fileLockException != null) {
                LOGGER.error("Couldn't delete custom Firefox profile directory", e);
                LOGGER.error("Perhaps caused by this exception:");
                if (taskKillException != null) {
                    LOGGER.error("Perhaps caused by this exception:", taskKillException);
                }
                if (fileLockException != null) {
                    LOGGER.error("Perhaps caused by this exception:", fileLockException);
                }
                throw new RuntimeException("Couldn't delete custom Firefox profile directory, presumably because task kill failed; see error LOGGER!", e);
            }
            throw e;
        }
        this.closed = true;
    }

    public Process getProcess() {
        return this.process;
    }

    private void waitForFileLockToGoAway(long timeout, long timeToWait) throws FileLockRemainedException {
        File lock = new File(this.customProfileDir, "parent.lock");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (lock.exists() || !this.makeSureFileLockRemainsGone(lock, timeToWait)) continue;
            return;
        }
        if (lock.exists()) {
            throw new FileLockRemainedException("Lock file still present! " + lock.getAbsolutePath());
        }
    }

    private boolean makeSureFileLockRemainsGone(File lock, long timeToWait) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeToWait) {
            AsyncExecute.sleepTight(500L);
            if (!lock.exists()) continue;
            return false;
        }
        return !lock.exists();
    }

    private void waitForFullProfileToBeCreated(long timeout) {
        File testFile = new File(this.customProfileDir, "extensions.ini");
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + timeout) {
            AsyncExecute.sleepTight(500L);
            if (!testFile.exists()) continue;
        }
        if (!testFile.exists()) {
            throw new RuntimeException("Timed out waiting for profile to be created!");
        }
        long subTimeout = timeout - (System.currentTimeMillis() - start);
        try {
            this.waitForFileLockToGoAway(subTimeout, 500L);
        }
        catch (FileLockRemainedException e) {
            throw new RuntimeException("Firefox refused shutdown while preparing a profile", e);
        }
    }

    public static void setChangeMaxConnections(boolean changeMaxConnections) {
        FirefoxChromeLauncher.changeMaxConnections = changeMaxConnections;
    }

    public void launchHTMLSuite(String suiteUrl, String browserURL, boolean multiWindow, String defaultLogLevel) {
        this.launch(LauncherUtils.getDefaultHTMLSuiteUrl(browserURL, suiteUrl, multiWindow, this.getPort(), defaultLogLevel));
    }

    public void launchRemoteSession(String browserURL, boolean multiWindow) {
        this.launch(LauncherUtils.getDefaultRemoteSessionUrl(browserURL, this.sessionId, multiWindow, this.getPort()));
    }

    public static class ChromeUrlConvert {
        public String convert(String httpUrl, int port) throws MalformedURLException {
            String query = LauncherUtils.getQueryString(httpUrl);
            String file = new File(new URL(httpUrl).getPath()).getName();
            return "chrome://src/content/" + file + "?" + query;
        }
    }

    private class FileLockRemainedException
    extends Exception {
        FileLockRemainedException(String message) {
            super(message);
        }
    }
}

