package org.epistem.servlet;

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;

/**
 * Utility base for servlets. 
 *
 * @author nick
 */
public class BaseServlet extends HttpServlet 
{
	/**
	 * Set the headers in the response to cause no caching. 
	 */
	public static void setNoCaching( HttpServletResponse response )
	{
		response.setHeader    ( "Pragma", "no-cache" );
		response.setDateHeader( "Expires", 0 );
		response.setHeader    ( "Cache-Control", "private, no-cache" );
	}
    
	/**
	 * Parse XML from the content of the HTTP request
	 */
    public Document parseXML( HttpServletRequest req ) 
        throws org.xml.sax.SAXException, IOException, ParserConfigurationException
    {
		DocumentBuilderFactory fact   = DocumentBuilderFactory.newInstance();
		DocumentBuilder        parser = fact.newDocumentBuilder();
        return parser.parse( req.getInputStream() );
    }
}
