package org.epistem.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
	
/**
 * A Response Wrapper which overrides the getWriter() and getOutputStream()
 * methods in order to use alternate writer and/or stream.
 * 
 * @author nick
 */
public class ResponseWrapper extends HttpServletResponseWrapper 
{
	private PrintWriter writer;
	private ServletOutputStream out;
		
	/**
	 * If Writer is not instanceof PrintWriter then wrap it in PrintWriter
	 * 
	 * @param response the response to wrap
	 * @param writer the writer to use in preference to the wrappee, null to use wrappee
	 * @param out the stream to use in preference to the wrappee, null to use wrappee	  
	 */		
	public ResponseWrapper( HttpServletResponse response, Writer writer, ServletOutputStream out ) {
		super( response );
			
		if( writer instanceof PrintWriter ) this.writer = (PrintWriter)writer;
		else this.writer = new PrintWriter( writer );

		this.out = out;
	}
	
	/**
	 * Set the output stream and make a PrintWriter wrapper for it.
	 * 
	 * @param response the response to wrap
	 * @param out the stream to use in preference to the wrappee, null to use wrappee	  
	 */
	public ResponseWrapper( HttpServletResponse response, ServletOutputStream out  ) {
		this( response, null, out );
	}		
		
	/**
	 * If Writer is not instanceof PrintWriter then wrap it in PrintWriter
	 * 
	 * @param response the response to wrap
	 * @param writer the writer to use in preference to the wrappee, null to use wrappee
	 */
	public ResponseWrapper( HttpServletResponse response, Writer writer ) {
		this( response, writer, null );
	}		

	/**
	 * Use the outputstream from the wrapped response and a NullPrintWriter
	 */
	public ResponseWrapper( HttpServletResponse response ) {
		this( response, new NullPrintWriter(), null );
	}				
		
	/**
	 *  @see javax.servlet.ServletResponse#getWriter()
	 */
	public PrintWriter getWriter() throws IOException {
		if( writer != null ) return writer;
			
		if( out != null )
		{
			writer = new PrintWriter(out);
			return writer;
		}
			
		return super.getWriter();
	}
		
	/**
	 *  @see javax.servlet.ServletResponse#getOutputStream()
	 */
	public ServletOutputStream getOutputStream() throws java.io.IOException	{
		if( out != null ) return out;
		return super.getOutputStream();
	}
}
