package examples;

import java.io.FileInputStream;

import com.anotherbigidea.flash.movie.ImageUtil;
import com.anotherbigidea.flash.movie.Movie;
import com.anotherbigidea.flash.movie.Shape;

/**
 * Example of importing a JPEG image.
 */
public class JPEG2SWF {
    /**
     * args[0] is filename of JPEG
     * args[1] is filename of output SWF
     */
    public static void main( String[] args ) throws Exception 
    {
        //--open the JPEG
        FileInputStream jpegIn = new FileInputStream( args[0] );
        
        //--create a shape that uses the image as a fill
        // (images cannot be placed directly - they can only be used as shape fills)
        int[] size = new int[2];
        Shape image = ImageUtil.shapeForImage( jpegIn, size );
        
        int width  = size[0];
        int height = size[1];
        jpegIn.close();      
        
        Movie movie = new Movie( width+10, height+10, 12, 5, null );
        movie.appendFrame().placeSymbol( image, 5, 5 );
        
        movie.write( args[1] );
    }
}