package org.javaswf.tools.screenshot;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Timer;

import javax.imageio.ImageIO;

/**
 * Utility that will check the system clipboard and save any image to a 
 * given dir.  This can be used to save screenshots.
 * 
 * @author nmain
 */
public class ScreenshotSaver {

    private File   dirToSaveTo;
    private String filenamePrefix;
    private int    imageIndex = 1;
    private static Timer timer;
    
    
    /**
     * Create a screenshot saver that will save screenshots from the system
     * clipboard into a given dir.  Initial index used to name the files is 1.
     * 
     * @param dirToSaveTo the (existing) dir to which images are saved
     * @param filenamePrefix the prefix for the filenames
     */
    public ScreenshotSaver( File dirToSaveTo, String filenamePrefix ) {
        this.dirToSaveTo    = dirToSaveTo;
        this.filenamePrefix = filenamePrefix;
    }
    
    /**
     * Save the current screenshot on the clipboard to a file named 
     * "filenamePrefix_n.png", where n is the current index.
     * The index is incremented if the save is successful.
     * 
     * @return false if there was no image on the clipboard
     */
    public boolean saveScreenShot() throws IOException {
        //SwingUtilities.invokeLater( new Runnable() { public void run() {
        //System.out.println( "Saving..." );
        
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
              
        //get the image contents
        Transferable contents = clipboard.getContents( null );
        if( ! contents.isDataFlavorSupported( DataFlavor.imageFlavor ) )
            return false;
        
        try {
            BufferedImage image = (BufferedImage) contents.getTransferData( DataFlavor.imageFlavor );
        
            String index = Integer.toString( imageIndex++ );
            while( index.length() < 5 ) index = "0" + index;
            
	        File imageFile = new File( dirToSaveTo, "screenshot_" + index + ".png" );
	        ImageIO.write( image, "png", imageFile );
	        StringSelection msg = new StringSelection( "image was saved as " + imageFile );
	        clipboard.setContents( msg, null );
	        
        } catch( Throwable ufe ) {
            return false;
        }

        //System.out.println( "Done" );        
        //}});
        
        return true;
    }
    
    /**
     * Saves screenshots on a 1 second cycle.
     * 
     * @param args args[0] is dir to save into
     */
    public static void main(String[] args) throws IOException {
        File dir = new File( args[0] );
        dir.mkdirs();

        ScreenshotSaver saver = new ScreenshotSaver( dir, "screenshot" );
        
        while(true) {
            try{ 
                Thread.sleep(1000);
                saver.saveScreenShot();
                continue;
            } catch( InterruptedException ignored ) {}
            break;
        }
        
        System.exit(0);
    }
}
