/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;

/**
 * A single frame
 * 
 * @author nick
 */
public class SWFFrame {

	private String      frameLabel;
	private SWFTimeline timeline;
	private boolean     isAnchorFrame;
	private List        tags;
	
	/* package */ SWFFrame( SWFTimeline timeline ) {		
		this.timeline = timeline;
	}
	
	/**
	 * Get the tag count
	 */
	public int getTagCount() {
	    if( tags == null ) return 0;
	    return tags.size();
	}
	
	/**
	 * Get an interator on the tags (SWFTag instances).
	 */
	public Iterator tags() {
	    if( tags == null ) return Collections.EMPTY_LIST.iterator();
	    return tags.iterator();
	}
	
	/**
	 * Append a tag to this frame and assert ownership of it. 
	 */
	public void appendTag( SWFTag tag ) {
	    tag.setFrame( this );
	    if( tags == null ) tags = new ArrayList();
	    tags.add( tag );
	}
	
	/**
	 * @return the time that contains this frame
	 */
	public SWFTimeline getTimeline() {
	    return timeline;
	}
	
	/**
	 * @return frame label, null if unlabelled
	 */
	public String getFrameLabel() {
	    return frameLabel;
	}
	
    /**
     * @return true if this is an Anchor Frame.
     */
    public boolean isAnchorFrame() {
        return isAnchorFrame;
    }
    
    /**
     * @param isAnchorFrame true if this is an Anchor Frame.
     */
    public void setAnchorFrame( boolean isAnchorFrame ) {
        this.isAnchorFrame = isAnchorFrame;
    }
    
	/* package */ void setLabel( String label ) {
	    this.frameLabel = label;
	}
	
	/**
	 * Writes the frame.
	 *  
	 * @param tagOutput tag output to write to
	 */
	public void write( SWFTagTypes tagOutput ) throws IOException {
	    
	    if( tags != null ) {
	        for( Iterator i = tags.iterator(); i.hasNext(); ) {
                SWFTag tag = (SWFTag) i.next();                
                tag.writeTag( tagOutput );
            }
	    }
	    
	    if( frameLabel != null ) {
	        tagOutput.tagFrameLabel( frameLabel, isAnchorFrame );
	    }
	    
	    tagOutput.tagShowFrame();
	}
}
