/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model.builders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.javaswf.swf.model.SWFDictionary;
import org.javaswf.swf.model.SWFFrame;
import org.javaswf.swf.model.SWFTag;
import org.javaswf.swf.model.SWFTimeline;
import org.javaswf.swf.model.tags.SWFFreeCharacterTag;
import org.javaswf.swf.model.tags.SWFOpaqueTag;

import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFTagTypesImpl;

/**
 * SWFTagTypeImpl that builds a timeline model.
 * 
 * @author Nick
 */
public class SWFTimelineBuilder extends SWFTagTypesImpl {

    protected SWFTimeline timeline;
    protected boolean isEnded;
    protected SWFFrame currentFrame;
    protected SWFDictionary dictionary = new SWFDictionary();
    
    /**
     * @param timeline the timeline to build
     */
    public SWFTimelineBuilder( SWFTimeline timeline ) {
        this.timeline = timeline;
    }
    
    protected SWFTimelineBuilder() {}
    
    /**
     * @return true if the end of the timeline has been reached
     */
    public boolean isEnded() {
        return isEnded;
    }
    
    /** Add a tag to the current frame */
    private void addTag( SWFTag tag ) {
    	if( currentFrame == null ) {
    		currentFrame = timeline.appendFrame( null );    		
    	}
    	
    	currentFrame.appendTag( tag );
    }
    
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFTags#tag(int, boolean, byte[])
     */
    public void tag( int tagType, boolean longTag, byte[] contents ) throws IOException {
        addTag( new SWFOpaqueTag( tagType, contents ) );
    }
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagEnd()
     */
    public void tagEnd() throws IOException {
        isEnded = true;
    }
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagFrameLabel(java.lang.String, boolean)
     */
    public void tagFrameLabel( String label, boolean isAnchor ) throws IOException {
    	if( currentFrame == null ) {
    		currentFrame = timeline.appendFrame( null );    		
    	}
    	
    	timeline.labelFrame( currentFrame, label );
    	currentFrame.setAnchorFrame( isAnchor );
    }
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagFrameLabel(java.lang.String)
     */
    public void tagFrameLabel( String label ) throws IOException {        
        tagFrameLabel( label, false );
    }
    /**
     * @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagShowFrame()
     */
    public void tagShowFrame() throws IOException {
    	if( currentFrame == null ) {
    		timeline.appendFrame( null );    		
    	}
    	
    	currentFrame = null;
    }
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagDefineBits(int, byte[]) */
	public void tagDefineBits(int id, byte[] imageData) throws IOException {
		// TODO Auto-generated method stub
		super.tagDefineBits(id, imageData);
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagDefineBitsJPEG2(int, byte[]) */
	public void tagDefineBitsJPEG2(int id, byte[] data) throws IOException {
		// TODO Auto-generated method stub
		super.tagDefineBitsJPEG2(id, data);
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagDefineBitsJPEG2(int, java.io.InputStream) */
	public void tagDefineBitsJPEG2(int id, InputStream jpegImage)
			throws IOException {
		ByteArrayOutputStream bout = new ByteArrayOutputStream();
		
		
		
		
		// TODO Auto-generated method stub
		super.tagDefineBitsJPEG2(id, jpegImage);
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagDefineBitsJPEG3(int, byte[], byte[]) */
	public void tagDefineBitsJPEG3(int id, byte[] imageData, byte[] alphaData)
			throws IOException {
		// TODO Auto-generated method stub
		super.tagDefineBitsJPEG3(id, imageData, alphaData);
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagDefineBitsLossless(int, int, int, int, com.anotherbigidea.flash.structs.Color[], byte[]) */
	public void tagDefineBitsLossless(int id, int format, int width,
			int height, Color[] colors, byte[] imageData) throws IOException {
		// TODO Auto-generated method stub
		super.tagDefineBitsLossless(id, format, width, height, colors,
				imageData);
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagDefineBitsLossless2(int, int, int, int, com.anotherbigidea.flash.structs.Color[], byte[]) */
	public void tagDefineBitsLossless2(int id, int format, int width,
			int height, Color[] colors, byte[] imageData) throws IOException {
		// TODO Auto-generated method stub
		super.tagDefineBitsLossless2(id, format, width, height, colors,
				imageData);
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagFreeCharacter(int) */
	public void tagFreeCharacter(int charId) throws IOException {
		addTag( new SWFFreeCharacterTag( charId, dictionary ));
		dictionary.removeSymbol( charId );
	}
	/** @see com.anotherbigidea.flash.interfaces.SWFTagTypes#tagJPEGTables(byte[]) */
	public void tagJPEGTables(byte[] jpegEncodingData) throws IOException {
		// TODO Auto-generated method stub
		super.tagJPEGTables(jpegEncodingData);
	}
}
