/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/

import java.io.IOException;

import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.writers.SWFTagTypesImpl;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;

/**
 * Removes all frame actions from a movie.
 * 
 * @author nick
 */
public class ActionRemover extends SWFTagTypesImpl {

	/**
	 * @param delegee the target tag interface
	 */
	public ActionRemover( SWFTagTypes delegee ) {
		super( delegee );
	}
	
	/** @see com.anotherbigidea.flash.interfaces.SWFHeader#header(int, long, int, int, int, int) */
	public void header(int version, long length, int twipsWidth,
			int twipsHeight, int frameRate, int frameCount) throws IOException {
		// recalc the length
		super.header(version, -1, twipsWidth, twipsHeight, frameRate, frameCount);
	}
	
	/** @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagDoAction() */
	public SWFActions tagDoAction() throws IOException {
		// skip actions
		return null;
	}
	
	/** @see com.anotherbigidea.flash.interfaces.SWFSpriteTagTypes#tagDoInitAction(int) */
	public SWFActions tagDoInitAction(int spriteId) throws IOException {
		// skip actions
		return null;
	}

	/**
	 * @param args args[0] = input filename, args[1] = output filename
	 */
	public static void main(String[] args) throws IOException {
		SWFWriter     writer  = new SWFWriter( args[1] );
		TagWriter     tagsOut = new TagWriter( writer );
		ActionRemover remover = new ActionRemover( tagsOut );
		TagParser     parser  = new TagParser( remover );
		SWFReader     reader  = new SWFReader( parser, args[0] );
		
		reader.ignoreProblemTags = true;		
		reader.readFile();
	}
}
