/**
 * License Agreement.
 *
 * Rich Faces - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.cdk.rd.mojo;

import java.io.File;
import java.util.Set;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.richfaces.cdk.rd.ComponentsScanner;
import org.richfaces.cdk.rd.RichWebSourceWalker;
import org.richfaces.cdk.rd.RichComponentsScanner;
import org.richfaces.cdk.rd.XhtmlFileNameFilter;

/**
 * @author Anton Belevich
 *
 * @goal assemblyScripts
 * @phase process-resources	
 * 	
 */
public class CreateScriptMojo extends AbstractMojo {
	
    /** Top maven project.
	 * 
	 * @parameter expression="${project}"
	 * @readonly
	 */
    protected MavenProject project;
    
	/**
	 *  outputScriptDirectory 
	 *  @parameter 
	 */
	private File outputScriptDirectory;
	
	/**
	 * scriptPackName
	 * @parameter;
	 */
	private String scriptPackName;
	
	/**
	 * webSourceDirectory
	 * @parameter expression="${basedir}/src/main/webapp" ;
	 */
	private File webSourceDirectory;
	
	/**
	 * loadOrder
	 * @parameter;
	 */
	private String loadOrder;
	
	public void execute() throws MojoExecutionException {
		try {
			SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
	  	  	SAXParser saxParser = saxParserFactory.newSAXParser();
	  	  	
	  	  	ComponentsScanner scanner = new RichComponentsScanner(saxParser);
			
	  	  	RichWebSourceWalker walker = new RichWebSourceWalker(scanner, new XhtmlFileNameFilter());
			walker.walk(webSourceDirectory);
			
			Set <String>result = scanner.getResult();
			for(String component: result) {
				System.out.println(component);
			}
			
		} catch (Exception e) {
			throw new MojoExecutionException(e.getMessage(),e);
		}		
		
	}
}
