package org.richfaces.realworld.domain;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

import org.hibernate.validator.Length;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.jboss.seam.annotations.Name;
@Entity
@Name("message")
@Table(name = "messages")
public class Message implements Serializable{

	private static final long serialVersionUID = -2449408843982851550L;

	@Id
	@GeneratedValue
	@Column(name = "MESSAGE_ID")
	private Long id;
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date date;
	
	private boolean readed;
	
	private boolean friendshipRequest;
	
	@Transient
	private String ownerLogin;
	
	@Column(length = 256, nullable = false)
    @NotNull
	@NotEmpty
    @Length(min=3)
	private String theme;
	
	@ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "AUTHOR_ID",nullable = false, updatable = false)
    @org.hibernate.annotations.ForeignKey(name = "FK_FROM_USERS_ID")
	private User author;
	
	@Column(length = 2000, nullable = false)
    @NotNull
	@NotEmpty
    @Length(min=3)
	private String message;
	
	@ManyToOne(fetch = FetchType.EAGER)
    @JoinColumn(name = "OWNER_ID", updatable = false)
    @org.hibernate.annotations.ForeignKey(name = "FK_FROM_USERS2_ID")
	private User owner;
	
	public Long getId() {
		return id;
	}
	
	public Date getDate() {
		return date;
	}
	
	public void setDate(Date date) {
		this.date = date;
	}
	
	public User getAuthor() {
		return author;
	}
	
	public void setAuthor(User author) {
		this.author = author;
	}
	
	public String getMessage() {
		return message;
	}
	
	public void setMessage(String message) {
		this.message = message;
	}
	
	public User getOwner() {
		return owner;
	}
	
	public void setOwner(User owner) {
		this.owner = owner;
	}

	public boolean isReaded() {
		return readed;
	}

	public void setReaded(boolean readed) {
		this.readed = readed;
	}

	public String getTheme() {
		return theme;
	}

	public void setTheme(String theme) {
		this.theme = theme;
	}

	public boolean isFriendshipRequest() {
		return friendshipRequest;
	}

	public void setFriendshipRequest(boolean friendshipRequest) {
		this.friendshipRequest = friendshipRequest;
	}

	public String getOwnerLogin() {
		return ownerLogin;
	}

	public void setOwnerLogin(String ownerLogin) {
		this.ownerLogin = ownerLogin;
	}

}
