package org.richfaces.realworld.domain;

import java.io.Serializable;
import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.jboss.seam.annotations.Name;

@Entity
@Name("rank")
@Table(name = "Ranks")
public class Rank implements Serializable{

	private static final long serialVersionUID = -3106134752407013128L;

	@Id
	@GeneratedValue
	@Column(name = "RANK_ID")
	private Long id;
	
	private Long total;

	private Long hits;
	
	@OneToOne(mappedBy = "rank")
	private Image image;
	
	public Long getId() {
		return id;
	}

	public Long getTotal() {
		return total;
	}
	
	public void setTotal(Long total) {
		this.total = total;
	}
	
	public Long getHits() {
		return hits;
	}
	
	public void setHits(Long hits) {
		this.hits = hits;
	}
	
	public Image getImage() {
		return image;
	}
	
	public void setImage(Image image) {
		this.image = image;
	}

	public double getRating() {
		double total2 = (double)total;
		double result = total2/hits;
		BigDecimal x = new BigDecimal(result);
		x = x.setScale(2, BigDecimal.ROUND_HALF_UP);
		return x.doubleValue();
	}
	
}
