package org.richfaces.realworld.service;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.Comment;
import org.richfaces.realworld.domain.Image;

@Name("imageAction")
@Stateless
public class ImageAction implements IImageAction {
	
	private static final String ALBUM_BY_ALBUM_NAME_AND_LOGIN_QUERY = "album-byAlbumNameAndLogin";
	private static final String LOGIN_PARAMETER = "login";
	private static final String ALBUM_NAME_PARAMETER = "albumName";
	@In(value="entityManager")
	EntityManager em;
	
	public void deleteImage(Image image){
		image.getAlbum().removeImage(image);
		em.flush();
	}

	public void editImage(Image image, boolean parentChanged) {
		if(parentChanged){
			Album albumPrevious = image.getAlbum();
			String login = albumPrevious.getOwner().getLogin();
			String albumName = image.getAlbumName();
			albumPrevious.removeImage(image);
			Album album = (Album)em.createNamedQuery(ALBUM_BY_ALBUM_NAME_AND_LOGIN_QUERY).setParameter(ALBUM_NAME_PARAMETER, albumName).setParameter(LOGIN_PARAMETER, login).getSingleResult();
			album.addImage(image);
		}
		image.getTags().clear();
		image.setTags(image.getMeta());
		em.flush();
	}

	public void addImage(Image image) {
		em.persist(image);
		image.getAlbum().addImage(image);
		image.getTags().clear();
		image.setTags(image.getMeta());
		em.flush();
	}
	
	public void deleteComment(Comment comment){
		comment.getImage().removeComment(comment);
		em.flush();
	}
	
	public void addComment(Comment comment){
		comment.getImage().addComment(comment);
		em.flush();
	}

	public void editComment(Comment comment) {
		em.flush();
	}

	public void vote(Image image, Long value) {
		Long total = image.getRank().getTotal();
		Long votes = image.getRank().getHits();
		total += value;
		votes++;
		image.getRank().setHits(votes);
		image.getRank().setTotal(total);
		em.flush();
	}
}
