package org.richfaces.realworld.service;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.richfaces.realworld.domain.Message;
import org.richfaces.realworld.domain.User;

@Name("messageAction")
@Stateless
public class MessageAction implements IMessageAction {
	
	private static final String LOGIN_PARAMETER = "login";
	@In(value="entityManager")
	EntityManager em;
	
	public void sendMessage(Message message){
		if(message.getOwnerLogin() != null){
			User user = (User)em.createQuery("from User u where u.login = :login")
			.setParameter(LOGIN_PARAMETER, message.getOwnerLogin())
			.getSingleResult();
			message.setOwner(user);
			message.setOwnerLogin(null);
		}
		if(message.isFriendshipRequest()){
			message.getAuthor().addFriendshipRequest(message.getOwner());
		}
		em.persist(message);
		em.flush();
	}
	
	public void deleteMessage(Message message){
		em.remove(message);
		message.getOwner().removeMessage(message);
		em.flush();
	}
	
	public void markAsReaded(Message message){
		message.setReaded(true);
		em.flush();
	}
}
