package org.richfaces.realworld.service;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.richfaces.realworld.domain.Image;

@Name("searchService")
@Stateless
public class SearchService implements ISearchService, Serializable
 {

	private static final String PERCENT = "%";
	public static final String DATE_NAMED_PARAMETER = ":date";
	public static final String UPLOAD_NAMED_PARAMETER = ":upload";
	public static final String WIDTH_NAMED_PARAMETER = ":width";
	public static final String HEIGHT_NAMED_PARAMETER = ":height";
	public static final String SIZE_NAMED_PARAMETER = ":size";
	public static final String CAMERA_NAMED_PARAMETER = ":camera";
	public static final String CHOICE_NAMED_PARAMETER = ":choice";
	public static final String SPINNER_VALUE_NAMED_PARAMETER = ":spinnerValue";
	private static final String DATE_PARAMETER = "date";
	private static final String UPLOAD_PARAMETER = "upload";
	private static final String WIDTH_PARAMETER = "width";
	private static final String HEIGHT_PARAMETER = "height";
	private static final String SIZE_PARAMETER = "size";
	private static final String CAMERA_PARAMETER = "camera";
	private static final String CHOICE_PARAMETER = "choice";
	private static final String SPINNER_VALUE_PARAMETER = "spinnerValue";
	private static final String METATAG_PARAMETER = "metatag";
	private static final String SEARCH_UNPOPULAR_QUERY_END = " order by r.total/r.hits asc";
	private static final String SEARCH_POPULAR_QUERY_END = " order by r.total/r.hits desc";
	private static final String SEARCH_RELEVANT_QUERY_BEGIN = "select i from Image i join i.rank r where i.album.shared=true";
	private static final String SEARCH_QUERY_END = " order by i.rank.total/i.rank.hits desc";
	private static final String SEARCH_QUERY_BEGIN = "select i from MetaTag t join t.parent i where upper(t.tag) like:metatag and i.album.shared=true";
	private static final String SEARCH_SENSITIVE_QUERY_BEGIN = "select i from MetaTag t join t.parent i where t.tag like:metatag and i.album.shared=true";
	private static final long serialVersionUID = -2750591521413940277L;
	public static final String STRICT_PARAMETER = "STRICT";
	public static final String CASE_SENSITIVE_PARAMETER = "CASE_SENSITIVE";
	@In(value="entityManager")
	EntityManager em;
	
	public List<Image> searchImages(String searchPattern, String additionalParams, Map<String, Object> paramMap){
		String fullQuery = null;
		if(paramMap != null && paramMap.get(CASE_SENSITIVE_PARAMETER) != null){
			boolean sensitive = (Boolean)paramMap.get(CASE_SENSITIVE_PARAMETER);
			if(sensitive){
				fullQuery = SEARCH_SENSITIVE_QUERY_BEGIN + additionalParams + SEARCH_QUERY_END;
			}else{
				fullQuery = SEARCH_QUERY_BEGIN + additionalParams + SEARCH_QUERY_END;
			}
		}
		Query prepared = prepareQuery(fullQuery, searchPattern, additionalParams, paramMap);
		return prepared.getResultList();
	}
	
	public List<Image> popularImages(String additionalParams, Map<String, Object> paramMap){
		String fullQuery = SEARCH_RELEVANT_QUERY_BEGIN + additionalParams + SEARCH_POPULAR_QUERY_END;
		Query prepared = prepareQuery(fullQuery, null, additionalParams, paramMap);
		return prepared.getResultList();
	}
	
	public List<Image> worstImages(String additionalParams, Map<String, Object> paramMap){
		String fullQuery = SEARCH_RELEVANT_QUERY_BEGIN + additionalParams + SEARCH_UNPOPULAR_QUERY_END;
		Query prepared = prepareQuery(fullQuery, null, additionalParams, paramMap);
		return prepared.getResultList();
	}
	
	private Query prepareQuery(String fullQuery ,String searchPattern, String additionalParams,
			Map<String, Object> paramMap) {
		Query prepared = em.createQuery(fullQuery);
		if(searchPattern != null){
			if(paramMap != null && paramMap.get(STRICT_PARAMETER) != null){
				String strict = paramMap.get(STRICT_PARAMETER).toString();
				if(strict.equals("STRICT")){
					prepared.setParameter(METATAG_PARAMETER, searchPattern.toUpperCase());
				}else if(strict.equals("START")){
					prepared.setParameter(METATAG_PARAMETER, searchPattern.toUpperCase()+PERCENT);
				}else if(strict.equals("END")){
					prepared.setParameter(METATAG_PARAMETER, PERCENT + searchPattern.toUpperCase());
				}else if(strict.equals("INCLUDE")){
					prepared.setParameter(METATAG_PARAMETER, PERCENT + searchPattern.toUpperCase()+PERCENT);
				}
			}else{
				prepared.setParameter(METATAG_PARAMETER, searchPattern.toUpperCase()+PERCENT);
			}
		}
		if(paramMap != null && paramMap.get(SPINNER_VALUE_NAMED_PARAMETER) != null){
			prepared.setParameter(SPINNER_VALUE_PARAMETER, paramMap.get(SPINNER_VALUE_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(CHOICE_NAMED_PARAMETER) != null){
			prepared.setParameter(CHOICE_PARAMETER, paramMap.get(CHOICE_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(DATE_NAMED_PARAMETER) != null){
			prepared.setParameter(DATE_PARAMETER, paramMap.get(DATE_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(UPLOAD_NAMED_PARAMETER) != null){
			prepared.setParameter(UPLOAD_PARAMETER, paramMap.get(UPLOAD_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(WIDTH_NAMED_PARAMETER) != null){
			prepared.setParameter(WIDTH_PARAMETER, paramMap.get(WIDTH_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(HEIGHT_NAMED_PARAMETER) != null){
			prepared.setParameter(HEIGHT_PARAMETER, paramMap.get(HEIGHT_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(SIZE_NAMED_PARAMETER) != null){
			prepared.setParameter(SIZE_PARAMETER, paramMap.get(SIZE_NAMED_PARAMETER));
		}
		if(paramMap != null && paramMap.get(CAMERA_NAMED_PARAMETER) != null){
			prepared.setParameter(CAMERA_PARAMETER, paramMap.get(CAMERA_NAMED_PARAMETER));
		}
		prepared.setMaxResults(20);
		return prepared;
	}

	public List<String> getAllCameras() {
		Query query = em.createQuery("select distinct i.cameraModel from Image i");
		return (List<String>)query.getResultList();
	}

	public List<String> getAllMetatags() {
		Query query = em.createQuery("select distinct t.tag from Image i join i.tags t");
		return (List<String>)query.getResultList();
	}
}
