/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.service;

import java.util.List;

import javax.ejb.Stateless;
import javax.persistence.EntityManager;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.FriendshipRequest;
import org.richfaces.realworld.domain.User;

@Name("userAction")
@Stateless
public class UserAction implements IUserAction {
	
	private static final String USER_FRIEND_EXIST_QUERY = "user-friendExist";

	private static final String USER_COUNT_MESSAGES_QUERY = "user-countMessages";

	private static final String USER_AVAILABLE_USERS_QUERY = "user-availableUsers";

	private static final String USER_EXIST_QUERY = "user-exist";

	private static final String USER_LOGIN_QUERY = "user-login";

	private static final String FRIEND_PARAMETER = "friend";

	private static final String PERCENT = "%";

	private static final String LOGIN_PARAMETER = "login";

	private static final String PASSWORD_PARAMETER = "password";

	private static final String USERNAME_PARAMETER = "username";

	@In(value="entityManager")
	EntityManager em;
	
	@In(create = true, required = true) @Out
	private User user;

	public User login(String username, String password) {
		return user = (User)em.createNamedQuery(USER_LOGIN_QUERY)
		.setParameter(USERNAME_PARAMETER, username)
		.setParameter(PASSWORD_PARAMETER, password)
		.getSingleResult();
	}

	public void register(User user) {
		em.persist(user);
		em.flush();
	}
	
	public void updateUser(User user) {
		em.flush();
		this.user = user;
	}
	
	public void resetUser(User user) {
		em.refresh(user);
		em.flush();
		this.user = user;
	}

	public boolean isUserExist(String login) {
		return em.createNamedQuery(USER_EXIST_QUERY)
		.setParameter(LOGIN_PARAMETER, login)
		.getResultList().size() != 0;
	}

	public List<String> getUsers(String suggest) {
		List<String> users = em.createNamedQuery(USER_AVAILABLE_USERS_QUERY)
		.setParameter(LOGIN_PARAMETER, suggest + PERCENT)
		.setMaxResults(10)
		.getResultList();
		return users;
	}
	
	public long countNotReadedMessages(User user){
		Long result = (Long)em.createNamedQuery(USER_COUNT_MESSAGES_QUERY)
		.setParameter(LOGIN_PARAMETER, user.getLogin())
		.getSingleResult();
		return result;
	}

	public void removeFromFriends(User owner, User removed) {
		owner.removeFriend(removed);
		removed.removeFriend(owner);
		em.flush();
	}

	public boolean friendExist(User user, User friend) {
		Long result = (Long)em.createNamedQuery(USER_FRIEND_EXIST_QUERY)
		.setParameter(LOGIN_PARAMETER, user.getLogin())
		.setParameter(FRIEND_PARAMETER, friend.getLogin())
		.getSingleResult();
		return result > 0;
	}

	public void addFriend(User user, User friend, FriendshipRequest request) {
		friend.removeFriendshipRequest(request);
		user.addFriend(friend);
		friend.addFriend(user);
		em.flush();
	}

	public void removeFromSharedAlbums(User user, Album album) {
		user.removeFromSharedAlbums(album);
		em.flush();
	}

	public void addSharedAlbum(Album album) {
		user.addSharedAlbum(album);
		album.getSharedOwners().add(user);
		em.flush();
	}

	public void loginAnonymous() {
		user = new User();	
	}
}