/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.fileupload;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

import javax.imageio.ImageIO;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.User;

@Name("imageLoader")
@Scope(ScopeType.CONVERSATION)
public class ImageLoader implements Serializable{

	private static final String DELIMITER = ":";

	private static final String JPEG = "jpeg";

	private static final long serialVersionUID = -1572789608594870285L;
	
	@In(create=true)
	FileManager fileManager;
	
	public synchronized void paintSearchImage(OutputStream stream, Object object) throws IOException {
		File image = fileManager.getImage(fileManager.transformToServerPath(object.toString()));
	    InputStream paintData = null;
	    byte[] data = new byte[(int)image.length() - 1];
	    FileInputStream fileInputStream = null;
	    BufferedInputStream bufferedInputStream = null;
	    if (image != null) {
			try {
				fileInputStream = new FileInputStream(image);
				bufferedInputStream = new BufferedInputStream(fileInputStream);
				paintData = bufferedInputStream;
				paintData.read(data);
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}finally{
				try {
					fileInputStream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					bufferedInputStream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					paintData.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
	    }
		stream.write(data);
	}
	
	public synchronized void paint(OutputStream out, Object data) throws IOException{
		if (null == data) {
			return;
		}
		File imageResource = fileManager.getImage(fileManager.transformToServerPath(data.toString()));;
		if (imageResource != null) {
			FileInputStream fileInputStream = new FileInputStream(imageResource);
			BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
			InputStream paintData = bufferedInputStream;
			if (null == paintData) {
				// throw new Exception("");
				// TODO
			}
			try{
			BufferedImage images = ImageIO.read(paintData);
			ImageIO.write(images, JPEG, out);
			}catch(Exception e){
				
			}finally{
				fileInputStream.close();
				bufferedInputStream.close();
				paintData.close();
			}
		}
	}
	
	public synchronized void paintGalleryImage(OutputStream out, Object data) throws IOException{
		if (null == data) {
			return;
		}
		String fileName = fileManager.getFileSeparator() + "galleries" + fileManager.getFileSeparator() + fileManager.transformToServerPath(data.toString());
		File imageResource = fileManager.getImage(fileName);
		if (imageResource != null) {
			FileInputStream fileInputStream = new FileInputStream(imageResource);
			BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
			InputStream paintData = bufferedInputStream;
			if (null == paintData) {
				// throw new Exception("");
				// TODO
			}
			try{
			BufferedImage images = ImageIO.read(paintData);
			ImageIO.write(images, JPEG, out);
			}catch(Exception e){
				
			}finally{
				fileInputStream.close();
				bufferedInputStream.close();
				paintData.close();
			}
		}
	}
	
	public synchronized void paintAvatar(OutputStream out, Object data) throws IOException{
		if (null == data) {
			return;
		}
		User user = (User)data;
		File imageResource = fileManager.getImage(user.getLogin() + fileManager.getFileSeparator() + "avatars" + fileManager.getFileSeparator() + user.getAvatarPath());
		if (imageResource != null) {
			FileInputStream fileInputStream = new FileInputStream(imageResource);
			BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
			InputStream paintData = bufferedInputStream;
			if (null == paintData) {
				// throw new Exception("");
				// TODO
			}
			try{
			BufferedImage image = ImageIO.read(paintData);
			ImageIO.write(image, JPEG, out);
			}catch(Exception e){
				
			}finally{
				fileInputStream.close();
				bufferedInputStream.close();
				paintData.close();
			}
		}
	}
	
	public synchronized void paintFriendAvatar(OutputStream out, Object data) throws IOException{
		if (null == data) {
			return;
		}
		String temp = data.toString();
		String[] array = temp.split(DELIMITER);
		File imageResource = fileManager.getImage(array[0] + fileManager.getFileSeparator() + "avatars" + fileManager.getFileSeparator() + array[1]);
		if (imageResource != null) {
			FileInputStream fileInputStream = new FileInputStream(imageResource);
			BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
			InputStream paintData = bufferedInputStream;
			if (null == paintData) {
				// throw new Exception("");
				// TODO
			}
			try{
			BufferedImage image = ImageIO.read(paintData);
			ImageIO.write(image, JPEG, out);
			}catch(Exception e){
				
			}finally{
				fileInputStream.close();
				bufferedInputStream.close();
				paintData.close();
			}
		}
	}
}
