package org.richfaces.realworld.gallery;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;

import javax.imageio.ImageIO;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;
import org.richfaces.realworld.domain.Gallery;
import org.richfaces.realworld.domain.GalleryImage;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.fileupload.FileItem;
import org.richfaces.realworld.fileupload.FileManager;
import org.richfaces.realworld.service.IGalleryAction;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
@Name("galleryBean")
@Scope(ScopeType.CONVERSATION)
public class GalleryBean {

	public GalleryBean(){
		selectedGallery = null;
	}
	@In(create=true) IGalleryAction galleryAction;
	@In(create=true) FileManager fileManager;
	private Gallery selectedGallery;
	
	private boolean uploadPanelRendered;
	private boolean galleryPanelRendered;
	private String author;
	private String desc;
	private String name;
	private String path;
	private String galleryName;

	private FileItem file;
	
	public void showUploadPanel(){
		setUploadPanelRendered(true);
		author = "";
		name = "";
		desc = "";
		path ="";
		file = null;
	}
	
	public void hideUploadPanel(){
		setUploadPanelRendered(false);
		GalleryImage image = new GalleryImage();
		image.setAuthor(author);
		image.setDescription(desc);
		image.setName(name);
		image.setUploaded(new Date());
		image.setPath(path);
		image.setSize(file.getLength()/1000);
		try {
			InputStream in = new ByteArrayInputStream(file.getData());
			Metadata metadata = JpegMetadataReader.readMetadata(in);
			Directory exifDirectory = metadata.getDirectory(ExifDirectory.class);
			Directory jpgDirectory = metadata.getDirectory(JpegDirectory.class);
			
			if(exifDirectory.containsTag(ExifDirectory.TAG_MODEL)){
				String cameraModel = exifDirectory.getString(ExifDirectory.TAG_MODEL);
				image.setCameraModel(cameraModel);
			}
			if(exifDirectory.containsTag(ExifDirectory.TAG_EXIF_IMAGE_WIDTH) && exifDirectory.containsTag(ExifDirectory.TAG_EXIF_IMAGE_HEIGHT)){
				int width = exifDirectory.getInt(ExifDirectory.TAG_EXIF_IMAGE_WIDTH);
				image.setWidth(width);
				int height = exifDirectory.getInt(ExifDirectory.TAG_EXIF_IMAGE_HEIGHT);
				image.setHeight(height);
			}else{
				if(jpgDirectory.containsTag(JpegDirectory.TAG_JPEG_IMAGE_HEIGHT)){
					int width = jpgDirectory.getInt(JpegDirectory.TAG_JPEG_IMAGE_WIDTH);
					image.setWidth(width);
					int height = jpgDirectory.getInt(JpegDirectory.TAG_JPEG_IMAGE_HEIGHT);
					image.setHeight(height);
				}
			}
			if(exifDirectory.containsTag(ExifDirectory.TAG_DATETIME_ORIGINAL)){
				Date time = exifDirectory.getDate(ExifDirectory.TAG_DATETIME_ORIGINAL);
				image.setCreated(time);
			}
		}
		catch (JpegProcessingException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (MetadataException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		galleryAction.addImage(selectedGallery, image);
		try {
			fileManager.addImage("galleries" + fileManager.getFileSeparator() + path, file.getData());
			file = null;
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public void showGalleryPanel(){
		setGalleryPanelRendered(true);
		galleryName = "";
	}
	
	public void selectGallery(Gallery gal){
		setSelectedGallery(gal);
	}
	
	public void goToGalleryHome(){
		setSelectedGallery(null);
	}
	
	public synchronized void listener(UploadEvent event) throws Exception{
	    UploadItem item = event.getUploadItem();
	    file = new FileItem();
	    file.setLength(item.getData().length);
	    file.setData(item.getData());
	    path = getSelectedGallery().getName() + fileManager.getFileSeparator()+item.getFileName();
	}
	
	public void hideGalleryPanel(){
		setGalleryPanelRendered(false);
		galleryAction.addGallery(galleryName);
		fileManager.addDirectory(fileManager.getUploadRoot() + fileManager.getFileSeparator() + "galleries" + fileManager.getFileSeparator()+ galleryName);
	}

	public Gallery getSelectedGallery() {
		return selectedGallery;
	}

	public void setSelectedGallery(Gallery selectedGallery) {
		this.selectedGallery = selectedGallery;
	}

	public boolean isUploadPanelRendered() {
		return uploadPanelRendered;
	}

	public void setUploadPanelRendered(boolean uploadPanelRendered) {
		this.uploadPanelRendered = uploadPanelRendered;
	}

	public boolean isGalleryPanelRendered() {
		return galleryPanelRendered;
	}

	public void setGalleryPanelRendered(boolean galleryPanelRendered) {
		this.galleryPanelRendered = galleryPanelRendered;
	}

	public String getAuthor() {
		return author;
	}

	public void setAuthor(String author) {
		this.author = author;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGalleryName() {
		return galleryName;
	}

	public void setGalleryName(String galleryName) {
		this.galleryName = galleryName;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public FileItem getFile() {
		return file;
	}

	public void setFile(FileItem file) {
		this.file = file;
	}
}
