/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.manager;

import javax.faces.model.SelectItem;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.fileupload.FileManager;
import org.richfaces.realworld.service.IAlbumAction;
import org.richfaces.realworld.tree.TreeAlbumItem;
import org.richfaces.realworld.tree.TreeRootItem;
import org.richfaces.realworld.util.SelectionHelper;

@Name("albumManager")
@Scope(ScopeType.CONVERSATION)
public class AlbumManager {

	@In(create=true, required=true)
	private IAlbumAction albumAction;
	
	@In(create=true) @Out TreeRootItem treeRoot;
	
	@In(create=true, required=true) @Out
	private Album album;
	
	@In
	private User user;
	
	@In(create=true)
	FileManager fileManager;
	
	@In @Out
	private SelectionHelper selectionHelper;
	
	public void addAlbum(){
		albumAction.addAlbum(album);
		treeRoot.getAvailableAlbums().add(new SelectItem(album.getName()));
		TreeAlbumItem albumItem = new TreeAlbumItem(album.getId(), treeRoot, album);
		treeRoot.addAlbumToTree(albumItem);
		fileManager.addDirectory(user.getLogin() + fileManager.getFileSeparator() + album.getName());
		selectionHelper.setSelectedImage(null);
		selectionHelper.setSelectedAlbum(albumItem.getAlbum());
		
	}

	public void editAlbum(Album album){
		boolean nameChanged = !album.getName().equals(album.getChangedName());
		if(nameChanged){
			String directoryOld = user.getLogin() + fileManager.getFileSeparator() + album.getName();
			String directoryNew = user.getLogin() + fileManager.getFileSeparator() + album.getChangedName();
			try {
				fileManager.renameDirectory(directoryOld, directoryNew);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			album.setName(album.getChangedName());
			album.setChangedName(null);
		}
		albumAction.editAlbum(album);
		treeRoot.updateChild(album);
	}

	public void deleteAlbum(Album album){
		String albumName = album.getName();
		albumAction.deleteAlbum(album);
		SelectItem item = treeRoot.getSelectItemByName(album.getName());
		treeRoot.getAvailableAlbums().remove(item);
		treeRoot.removeChild(album.getId());
		fileManager.deleteDirectory(user.getLogin() + fileManager.getFileSeparator() + albumName);
		selectionHelper.setSelectedAlbum(user.getChildAlbums().get(0));
		selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(0));
	}
	
	public void updateSelectedAlbum(){
		selectionHelper.setSelectedAlbum(user.getAlbumByName(selectionHelper.getSelectedAlbum().getName()));
		selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(0));
		selectionHelper.setSelectedImageIndex(1);
		selectionHelper.setUserAlbumSelected(true);
	}
}
