/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.faces.model.SelectItem;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.service.ISearchService;
import org.richfaces.realworld.service.SearchService;

@Name("searchBean")
@Scope(ScopeType.CONVERSATION)
public class SearchBean implements Serializable {

	@In("#{messages['equals']}") private String EQUALS_CHOICE;
	@In("#{messages['less']}") private String LESS_CHOICE;
	@In("#{messages['more']}") private String MORE_CHOICE;
	@In("#{messages['nomatter']}") private String NO_MATTER_CHOICE;

	private boolean collapsed;
	
	private static final String EQUALS = "= ";

	private static final String LESSTHEN = "< ";

	private static final String GREATTHEN = "> ";

	private static final String DATE_ADDON = " and i.created";
	
	private static final String UPLOAD_ADDON = " and i.upload";
	
	private static final String HEIGHT_ADDON = " and i.height";
	
	private static final String SIZE_ADDON = " and i.size";
	
	private static final String WIDTH_ADDON = " and i.width";
	
	private static final String CAMERA_ADDON = " and i.cameraModel";

	private static final String VOTES_ADDON = " and i.rank.hits";

	private static final String SPINNER_ADDON = " and i.rank.total/i.rank.hits";

	private static final long serialVersionUID = 5071655218132021316L;

	private boolean caseSensitive;
	
	@In(required=false)
    private SearchBeanHelper helper;

	@In(create=true)
	private ISearchService searchService;
	
	private String searchPattern;
	
	private Long matcherChoice;
	
	private Long spinnerChoice;
	
	private Long uploadChoice;
	
	private Long sizeChoice;
	
	private Long widthChoice;
	
	private Long heightChoice;
	
	private Long dateChoice;
	
	private Long votesChoice;
	
	private Long numberOfVotes;
	
	private Date date;
	
	private String camera;
	    
	private int height;
	    
	private double size;
	    
	private int width;
	    
	private Date uploadDate;
	
	private List<Image> findedImages = new ArrayList<Image>();
	
	public List<SelectItem> getItems() {
	      List<SelectItem> list = new ArrayList<SelectItem>(4);
	      list.add(new SelectItem(Long.valueOf(0L), NO_MATTER_CHOICE));
	      list.add(new SelectItem(Long.valueOf(1L), MORE_CHOICE));
	      list.add(new SelectItem(Long.valueOf(2L), LESS_CHOICE));
	      list.add(new SelectItem(Long.valueOf(3L), EQUALS_CHOICE));
	      return list;
	   }
	
	public List<SelectItem> getMatchItems() {
	      List<SelectItem> list = new ArrayList<SelectItem>(4);
	      list.add(new SelectItem(Long.valueOf(0L), "Strict"));
	      list.add(new SelectItem(Long.valueOf(1L), "Start with"));
	      list.add(new SelectItem(Long.valueOf(2L), "End with"));
	      list.add(new SelectItem(Long.valueOf(3L), "Include"));
	      return list;
	   }
	
	private String getAstFromIndex(Long item){
		if(item == 1L){
			return GREATTHEN;
		}else if(item == 2L){
			return LESSTHEN;
		}else if(item == 3L){
			return EQUALS;
		}
		return null;
	}
	
	private String getMatcher(Long item){
		if(item == 1L){
			return "START";
		}else if(item == 2L){
			return "END";
		}else if(item == 3L){
			return "INCLUDE";
		}else if(item == 0L){
			return "STRICT";
		}
		return null;
	}
	
	public List<Image> searchImages(){
		String additionalParams = populateAdditionalParams();
		Map<String, Object> paramMap = null;
		paramMap = populateMap(additionalParams);
		findedImages = searchService.searchImages(this.searchPattern, additionalParams, paramMap);
		return findedImages;
	}
	
	public List<Image> popularImages(){
		String additionalParams = populateAdditionalParams();
		Map<String, Object> paramMap = null;
		paramMap = populateMap(additionalParams);
		findedImages = searchService.popularImages(additionalParams, paramMap);
		return findedImages;
	}
	
	private Map<String, Object> populateMap(String additionalParams) {
		Map<String, Object> map = new HashMap<String, Object>();
		if(additionalParams.lastIndexOf(SearchService.SPINNER_VALUE_NAMED_PARAMETER) != -1){
			map.put(SearchService.SPINNER_VALUE_NAMED_PARAMETER, Long.valueOf(helper.getInputSpinner().getValue().toString()));
		}
		if(additionalParams.lastIndexOf(SearchService.CHOICE_NAMED_PARAMETER) != -1){
			map.put(SearchService.CHOICE_NAMED_PARAMETER, numberOfVotes);
		}
		if(additionalParams.lastIndexOf(SearchService.DATE_NAMED_PARAMETER) != -1){
			map.put(SearchService.DATE_NAMED_PARAMETER, date);
		}
		if(additionalParams.lastIndexOf(SearchService.UPLOAD_NAMED_PARAMETER) != -1){
			map.put(SearchService.UPLOAD_NAMED_PARAMETER, uploadDate);
		}
		if(additionalParams.lastIndexOf(SearchService.SIZE_NAMED_PARAMETER) != -1){
			map.put(SearchService.SIZE_NAMED_PARAMETER, size);
		}
		if(additionalParams.lastIndexOf(SearchService.WIDTH_NAMED_PARAMETER) != -1){
			map.put(SearchService.WIDTH_NAMED_PARAMETER, width);
		}
		if(additionalParams.lastIndexOf(SearchService.HEIGHT_NAMED_PARAMETER) != -1){
			map.put(SearchService.HEIGHT_NAMED_PARAMETER, height);
		}
		if(additionalParams.lastIndexOf(SearchService.CAMERA_NAMED_PARAMETER) != -1){
			map.put(SearchService.CAMERA_NAMED_PARAMETER, camera);
		}
		if(matcherChoice != null){
			map.put(SearchService.STRICT_PARAMETER, getMatcher(matcherChoice));
		}
		map.put(SearchService.CASE_SENSITIVE_PARAMETER, caseSensitive);
		return map;
	}

	public void collapse(){
		this.setCollapsed(!collapsed);
	}
	
	private String populateAdditionalParams() {
		StringBuilder additionalParams = new StringBuilder("");
		if(spinnerChoice != null && spinnerChoice > 0L){
			additionalParams.append(SPINNER_ADDON);
			additionalParams.append(getAstFromIndex(spinnerChoice));
			additionalParams.append(SearchService.SPINNER_VALUE_NAMED_PARAMETER);
		}
		if(votesChoice != null && votesChoice > 0L){
			additionalParams.append(VOTES_ADDON);
			additionalParams.append(getAstFromIndex(votesChoice));
			additionalParams.append(SearchService.CHOICE_NAMED_PARAMETER);
		}
		if(dateChoice != null && dateChoice > 0L && date != null){
			additionalParams.append(DATE_ADDON);
			additionalParams.append(getAstFromIndex(dateChoice));
			additionalParams.append(SearchService.DATE_NAMED_PARAMETER);
		}
		if(uploadChoice != null && uploadChoice > 0L && uploadDate != null){
			additionalParams.append(UPLOAD_ADDON);
			additionalParams.append(getAstFromIndex(uploadChoice));
			additionalParams.append(SearchService.UPLOAD_NAMED_PARAMETER);
		}
		if(widthChoice != null && widthChoice > 0L){
			additionalParams.append(WIDTH_ADDON);
			additionalParams.append(getAstFromIndex(widthChoice));
			additionalParams.append(SearchService.WIDTH_NAMED_PARAMETER);
		}
		if(heightChoice != null && heightChoice > 0L){
			additionalParams.append(HEIGHT_ADDON);
			additionalParams.append(getAstFromIndex(heightChoice));
			additionalParams.append(SearchService.HEIGHT_NAMED_PARAMETER);
		}
		if(sizeChoice != null && sizeChoice > 0L){
			additionalParams.append(SIZE_ADDON);
			additionalParams.append(getAstFromIndex(sizeChoice));
			additionalParams.append(SearchService.SIZE_NAMED_PARAMETER);
		}
		if(camera!= null && !camera.equals("")){
			additionalParams.append(CAMERA_ADDON);
			additionalParams.append(EQUALS);
			additionalParams.append(SearchService.CAMERA_NAMED_PARAMETER);
		}
		return additionalParams.toString();
	}

	public List<Image> worstImages(){
		String additionalParams = populateAdditionalParams();
		Map<String, Object> paramMap = null;
		if(!additionalParams.equals("")){
			paramMap = populateMap(additionalParams);
		}
		findedImages = searchService.worstImages(additionalParams, paramMap);
		return findedImages;
	}

	public List<String> getAllCameras(){
		List<String> cameras = new ArrayList<String>();
		cameras = searchService.getAllCameras();
		return cameras;
	}
	
	public List<String> getAllMetatags(){
		List<String> metatags = new ArrayList<String>();
		metatags = searchService.getAllMetatags();
		return metatags;
	}
	
	public String getSearchPattern() {
		return searchPattern;
	}

	public void setSearchPattern(String searchPattern) {
		this.searchPattern = searchPattern;
	}

	public Long getSpinnerChoice() {
		return spinnerChoice;
	}

	public void setSpinnerChoice(Long spinnerChoice) {
		this.spinnerChoice = spinnerChoice;
	}

	public Long getDateChoice() {
		return dateChoice;
	}

	public void setDateChoice(Long dateChoice) {
		this.dateChoice = dateChoice;
	}

	public Long getVotesChoice() {
		return votesChoice;
	}

	public void setVotesChoice(Long votesChoice) {
		this.votesChoice = votesChoice;
	}

	public Long getNumberOfVotes() {
		return numberOfVotes;
	}

	public void setNumberOfVotes(Long numberOfVotes) {
		this.numberOfVotes = numberOfVotes;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public List<Image> getFindedImages() {
		return findedImages;
	}

	public void setFindedImages(List<Image> findedImages) {
		this.findedImages = findedImages;
	}

	public String getCamera() {
		return camera;
	}

	public void setCamera(String camera) {
		this.camera = camera;
	}

	public int getHeight() {
		return height;
	}

	public void setHeight(int height) {
		this.height = height;
	}

	public double getSize() {
		return size;
	}

	public void setSize(double size) {
		this.size = size;
	}

	public int getWidth() {
		return width;
	}

	public void setWidth(int width) {
		this.width = width;
	}

	public Date getUploadDate() {
		return uploadDate;
	}

	public void setUploadDate(Date uploadDate) {
		this.uploadDate = uploadDate;
	}

	public Long getUploadChoice() {
		return uploadChoice;
	}

	public void setUploadChoice(Long uploadChoice) {
		this.uploadChoice = uploadChoice;
	}

	public Long getSizeChoice() {
		return sizeChoice;
	}

	public void setSizeChoice(Long sizeChoice) {
		this.sizeChoice = sizeChoice;
	}

	public Long getWidthChoice() {
		return widthChoice;
	}

	public void setWidthChoice(Long widthChoice) {
		this.widthChoice = widthChoice;
	}

	public Long getHeightChoice() {
		return heightChoice;
	}

	public void setHeightChoice(Long heightChoice) {
		this.heightChoice = heightChoice;
	}

	public boolean isCollapsed() {
		return collapsed;
	}

	public void setCollapsed(boolean collapsed) {
		this.collapsed = collapsed;
	}

	public boolean isCaseSensitive() {
		return caseSensitive;
	}

	public void setCaseSensitive(boolean caseSensitive) {
		this.caseSensitive = caseSensitive;
	}

	public Long getMatcherChoice() {
		return matcherChoice;
	}

	public void setMatcherChoice(Long matcherChoice) {
		this.matcherChoice = matcherChoice;
	}
}
