package org.richfaces.realworld.servlet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifDirectory;

public class PictureServlet extends javax.servlet.http.HttpServlet {

	public static final long serialVersionUID = 596009789004L;
	private static final String UPLOAD_ROOT = "uploadRoot";

	protected void doGet(HttpServletRequest request,
			HttpServletResponse response) throws ServletException, IOException {
		String pathInfo = request.getPathInfo();
		String fileName = WebUtil.getFileName(pathInfo);
		if (fileName == null) {
			String contextPath = request.getContextPath();
			response.sendRedirect(contextPath + "/error.seam");
			return;
		}
		ServletContext context = getServletContext();
		FileHelper helper = new FileHelper(context.getInitParameter(UPLOAD_ROOT));
		File file = helper.getImage(fileName);
		/*try {
			Metadata metadata = JpegMetadataReader.readMetadata(file);
			Directory exifDirectory = metadata.getDirectory(ExifDirectory.class);
			if(exifDirectory.containsTag(ExifDirectory.TAG_MODEL)){
				String cameraModel = exifDirectory.getString(ExifDirectory.TAG_MODEL);
				System.out.println(cameraModel);
			}
			if(exifDirectory.containsTag(ExifDirectory.TAG_EXIF_IMAGE_WIDTH)){
				int width = exifDirectory.getInt(ExifDirectory.TAG_EXIF_IMAGE_WIDTH);
				System.out.println(width);
			}
			if(exifDirectory.containsTag(ExifDirectory.TAG_EXIF_IMAGE_HEIGHT)){
				int height = exifDirectory.getInt(ExifDirectory.TAG_EXIF_IMAGE_HEIGHT);
				System.out.println(height);
			}
			if(exifDirectory.containsTag(ExifDirectory.TAG_DATETIME_ORIGINAL)){
				Date time = exifDirectory.getDate(ExifDirectory.TAG_DATETIME_ORIGINAL);
				System.out.println(time);
			}
		}
		catch (JpegProcessingException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (MetadataException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}*/
		InputStream paintData = null;
		byte[] data = new byte[(int) file.length() - 1];
		FileInputStream fileInputStream = null;
		BufferedInputStream bufferedInputStream = null;
		if (file != null) {
			try {
				fileInputStream = new FileInputStream(file);
				bufferedInputStream = new BufferedInputStream(fileInputStream);
				paintData = bufferedInputStream;
				paintData.read(data);
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} finally {
				try {
					fileInputStream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					bufferedInputStream.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				try {
					paintData.close();
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
		}
		response.setContentType("image/jpg");
		response.setContentLength((int) data.length - 1);
		response.getOutputStream().write(data);
		response.getOutputStream().flush();
		response.getOutputStream().close();
	}
}
