/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.slideshow;

import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.error.ErrorHandler;
import org.richfaces.realworld.tree.TreeSelectionManager;

@Name("slideshow")
@Scope(ScopeType.CONVERSATION)
public class SlideshowBean implements Serializable{

	private static final int INITIAL_DELAY = 10000;

	private static final int DELAY = 1000;

	private static final long serialVersionUID = 7801877176558409702L;

	@In(required=false) @Out(required=false)
	SlideshowHelper slideshowHelper;
	
	@In
	TreeSelectionManager treeSelectionManager;
	
	private boolean active;
	
	private int interval = INITIAL_DELAY;

	public int getInterval() {
		return interval;
	}

	public void setInterval(int interval) {
		this.interval = interval;
	}

	public boolean isActive() {
		return active;
	}

	public void setActive(boolean active) {
		this.active = active;
	}
	
	public void startSlideshow(){
		active = true;
	}
	
	public void stopSlideshow(){
		active = false;
	}

	public void updateInterval(){
		this.setInterval((int)(DELAY * Long.valueOf(slideshowHelper.getInputSlider().getValue().toString())));
	}
	@ErrorHandler
	public void incrementSlide() {
		treeSelectionManager.incrementSlideshowIndex();
	}
}
