/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.tree;

import java.util.Iterator;

import org.richfaces.model.TreeNode;
import org.richfaces.realworld.domain.Image;

public class TreeImageItem implements TreeNode {

	private static final String IMAGE_NODE_TYPE = "image";
	private static final long serialVersionUID = 6514596192023597908L;
	private long id;
	private Image image;
	
	private TreeAlbumItem album;

	public TreeImageItem(long id, TreeAlbumItem album, Image image) {
		this.id = id;
		this.album = album;
		this.image = image;
	}
	
	public void addChild(Object identifier, TreeNode child) {
		
	}

	public TreeNode getChild(Object id) {
		return null;
	}

	public Iterator getChildren() {
		return null;
	}

	public Object getData() {
		return this;
	}

	public TreeNode getParent() {
		return album;
	}

	public boolean isLeaf() {
		return true;
	}

	public void removeChild(Object id) {
		
	}

	public void setData(Object data) {
	}

	public void setParent(TreeNode parent) {
		this.album = (TreeAlbumItem) parent;
	}

	public long getId() {
		return id;
	}
	
	public String getType() {
		return IMAGE_NODE_TYPE;
	}

	public Image getImage() {
		return image;
	}

	public void setImage(Image image) {
		this.image = image;
	}
	
}
