/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.io.Serializable;
import java.util.Date;

import javax.faces.event.ActionEvent;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Comment;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.User;
import org.richfaces.realworld.manager.ImageManager;

@Name("commentPopupHelper")
@Scope(ScopeType.CONVERSATION)
public class CommentPopupHelper implements Serializable{

	private static final long serialVersionUID = 2561824019376412988L;

	private String caption;
	
	private String actionName;
	
	@In(create=true, required=true) @Out
	private Comment comment;
	
	@In
	private User user; 
	
	@In(create=true, required=true)
	private ImageManager imageManager;
	
	public String getCaption() {
		return caption;
	}

	public void setCaption(String caption) {
		this.caption = caption;
	}

	public String getActionName() {
		return actionName;
	}

	public void setActionName(String actionName) {
		this.actionName = actionName;
	}
	
	public void initComment( String actionName, String caption, Comment comment, Image image){
		this.caption = caption;
		this.actionName = actionName;
		if(null != comment){
			this.comment = comment;
		}else{
			this.comment = new Comment();
			this.comment.setAuthor(user);
			this.comment.setImage(image);
			this.comment.setDate(new Date());
		}
	}
	
	public void editComment(ActionEvent event){
		imageManager.editComment(this.comment);
	}
	
	public void addComment(ActionEvent event){
		imageManager.addComment(this.comment);
	}
}
