/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.io.Serializable;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Album;
import org.richfaces.realworld.domain.User;

@Name("friendHelper")
@Scope(ScopeType.CONVERSATION)
public class FriendHelper implements Serializable{
	
	private static final long serialVersionUID = 4735350615108906608L;
	
	@In(required=false) @Out(required=false)
	private SelectionHelper selectionHelper;
	
	@In(required=false)
	ComboboxHelper comboboxHelper;
	
	public void chooseAlbum(User friend){
		selectionHelper.setSelectedAlbum(friend.getAlbumByName(comboboxHelper.getAlbumName()));
		selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(0));
		selectionHelper.setSelectedImageIndex(1);
		selectionHelper.setUserAlbumSelected(false);
	}
	
	public void chooseAlbum(Album album){
		selectionHelper.setSelectedAlbum(album);
		selectionHelper.setSelectedImage(selectionHelper.getSelectedAlbum().getImages().get(0));
		selectionHelper.setSelectedImageIndex(1);
		selectionHelper.setUserAlbumSelected(false);
	}
}
