/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.util.HashSet;
import java.util.Set;

import javax.faces.context.FacesContext;

import org.ajax4jsf.component.UIRepeat;
import org.jboss.seam.annotations.Name;
import org.richfaces.component.html.HtmlInputText;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.MetaTag;

@Name(value="imageBinder")
public class ImageBinder {

	HtmlInputText metaRef;
    private UIRepeat repeater;
    private Set<Integer> keys = null;
    
    /**
     * @return the keys
     */
    public Set<Integer> getKeys() {
        return keys;
    }

    /**
     * @param keys the keys to set
     */
    public void setKeys(Set<Integer> keys) {
        this.keys = keys;
    }

    public void setRepeater(UIRepeat repeater) {
        this.repeater = repeater;
    }

    public UIRepeat getRepeater() {
        return repeater;
    }

    public HtmlInputText getMetaRef() {
        return metaRef;
    }

    public void setMetaRef(HtmlInputText metaRef) {
        this.metaRef = metaRef;
    }
    
    public String change(Image image){
        
        Set<Integer> keys = new HashSet<Integer>();
        int rowKey = getRepeater().getRowIndex();
        keys.add(rowKey);
        setKeys(keys);
        metaRef.processValidators(FacesContext.getCurrentInstance());
        metaRef.processUpdates(FacesContext.getCurrentInstance());
        MetaTag metaTag = new MetaTag();
		metaTag.setTag(metaRef.getValue().toString());
		metaTag.setParent(image);
        image.getMeta().add(metaTag);
        return null;
    }
    
    public void addTag(Image image){
		MetaTag metaTag = new MetaTag();
		metaTag.setTag("");
		metaTag.setParent(image);
		image.getMeta().add(metaTag);
	}
	
	public void removeTag(MetaTag tag, Image image){
		image.getMeta().remove(tag);
	}
}
