/**
 * License Agreement.
 *
 *  JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007  Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */
package org.richfaces.realworld.util;

import java.io.Serializable;
import java.util.ArrayList;

import javax.faces.event.ActionEvent;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.richfaces.realworld.domain.Image;
import org.richfaces.realworld.domain.MetaTag;
import org.richfaces.realworld.manager.ImageManager;

@Name("imagePopupHelper")
@Scope(ScopeType.CONVERSATION)
public class ImagePopupHelper implements Serializable{

	private static final long serialVersionUID = 2561824019376412988L;
	
	@In(create=true, required=true) @Out
	private Image image;
	
	@In(create=true, required=true)
	private ImageManager imageManager;
	
	public void initImagePopup(Image image){
		if(null != image){
			this.image = image;
			image.setMeta(new ArrayList<MetaTag>(image.getTags()));
		}else{
			this.image = new Image();
		}
	}
	
	public void editImage(ActionEvent event){
		imageManager.editImage(this.image);
	}
}
