package org.richfaces.realworld.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

@Name("linkBuilder")
@Scope(ScopeType.CONVERSATION)
public class LinkBuilder implements Serializable{

	private static final long serialVersionUID = 2561824019376412988L;
	private static final String MINI_FORMAT = "_mini";
	private static final String MEDIUM_FORMAT = "_medium";
	@In("#{messages['small']}") private String SMALL;
	@In("#{messages['medium']}") private String MEDIUM;
	@In("#{messages['full']}") private String FULL;
	private Long scaleChoice = 1L;
	private String generatedLink;
	private String currentFormat = URL;
	private String path;
	private static String URL = "URL";
	private static String HTML = "HTML";
	private static String FORUM = "Forum";
	private static String HTML_PATTERN = "<a href='%s'><img src='%s' border='0'></a>";
	private static String FORUM_PATTERN = "[URL=%s][IMG]%s[/IMG][/URL]";
	
	public String getGeneratedLink() {
		
		ServletRequest servletRequest = ((ServletRequest)(FacesContext.getCurrentInstance().getExternalContext().getRequest()));
		ServletContext s = (ServletContext)(FacesContext.getCurrentInstance().getExternalContext().getContext());
		String protocol = servletRequest.getProtocol().equals("HTTP/1.1") || servletRequest.getProtocol().equals("HTTP/1.0") ? "http://" : "https://" ;
		String servletPath = protocol + servletRequest.getLocalAddr() + ":" + servletRequest.getLocalPort() + s.getContextPath();
		String link = null;
		String tempPath = null;
		if(getScaleChoice() == 3L){
			tempPath = MINI_FORMAT;
		}else if(getScaleChoice() == 2L){
			tempPath = MEDIUM_FORMAT;
		}else if(getScaleChoice() == 1L){
			tempPath="";
		}
		if(null == path){
			return "";
		}
		if(getCurrentFormat().equals(URL)){
			link =  servletPath + "/pictures/" + transformPath(path, tempPath);
		}else
		if(getCurrentFormat().equals(HTML)){
			link =  String.format(HTML_PATTERN, servletPath, servletPath+ "/pictures/" + transformPath(path, tempPath));
		}else
		if(getCurrentFormat().equals(FORUM)){
			link =  String.format(FORUM_PATTERN, servletPath, servletPath+ "/pictures/" + transformPath(path, tempPath));
		}
		return link;
	}
	
	private String transformPath(String target, String substitute){
		String begin = target.substring(0, target.lastIndexOf("."));
		String end = target.substring(target.lastIndexOf("."));
		return begin + substitute + end;
	}

	public void setGeneratedLink(String generatedLink) {
		this.generatedLink = generatedLink;
	}

	public List<SelectItem> getItems() {
	      List<SelectItem> list = new ArrayList<SelectItem>(4);
	      list.add(new SelectItem(Long.valueOf(1L), FULL));
	      list.add(new SelectItem(Long.valueOf(2L), MEDIUM));
	      list.add(new SelectItem(Long.valueOf(3L), SMALL));
	      return list;
	   }

	public Long getScaleChoice() {
		return scaleChoice;
	}

	public void setScaleChoice(Long scaleChoice) {
		this.scaleChoice = scaleChoice;
	}
	
	public void selectFormat(String format){
		setCurrentFormat(format);
	}

	public String getCurrentFormat() {
		return currentFormat;
	}

	public void setCurrentFormat(String currentFormat) {
		this.currentFormat = currentFormat;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}
	
	public void setScale(Long choice){
		setScaleChoice(choice);
	}
}
