/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.ajax4jsf.bean;

/**
 * A4JInclude Test Bean
 * @author Alexandr Levkovsky
 *
 */
public class A4JIncludeTestBean {

    private Integer include1Counter = 0;
    private Integer include2Counter = 0;
    private Integer include3Counter = 0;
    private Boolean include3ChildRenderedFlag = true;
    private Boolean include4RenderedFlag = true;
    private String inputValue;

    /**
     * @return the inputValue
     */
    public String getInputValue() {
	return inputValue;
    }

    /**
     * @param inputValue the inputValue to set
     */
    public void setInputValue(String inputValue) {
	this.inputValue = inputValue;
    }

    /**
     * @return the include1Counter
     */
    public Integer getInclude1Counter() {
	return include1Counter;
    }

    /**
     * @param include1Counter the include1Counter to set
     */
    public void setInclude1Counter(Integer include1Counter) {
	this.include1Counter = include1Counter;
    }

    /**
     * @return the include2Counter
     */
    public Integer getInclude2Counter() {
	return include2Counter;
    }

    /**
     * @param include2Counter the include2Counter to set
     */
    public void setInclude2Counter(Integer include2Counter) {
	this.include2Counter = include2Counter;
    }

    /**
     * @return the include3Counter
     */
    public Integer getInclude3Counter() {
	return include3Counter;
    }

    /**
     * @param include3Counter the include3Counter to set
     */
    public void setInclude3Counter(Integer include3Counter) {
	this.include3Counter = include3Counter;
    }

    /**
     * @return the include4RenderedFlag
     */
    public Boolean getInclude4RenderedFlag() {
        return include4RenderedFlag;
    }

    /**
     * @param include4RenderedFlag the include4RenderedFlag to set
     */
    public void setInclude4RenderedFlag(Boolean include4RenderedFlag) {
        this.include4RenderedFlag = include4RenderedFlag;
    }
    
    

    /**
     * @return the include3ChildRenderedFlag
     */
    public Boolean getInclude3ChildRenderedFlag() {
        return include3ChildRenderedFlag;
    }

    /**
     * @param include3ChildRenderedFlag the include3ChildRenderedFlag to set
     */
    public void setInclude3ChildRenderedFlag(Boolean include3ChildRenderedFlag) {
        this.include3ChildRenderedFlag = include3ChildRenderedFlag;
    }

    public String b1Action() {
	include2Counter++;
	return null;
    }

    public String b2Action() {
	include1Counter++;
	include2Counter++;
	return null;
    }

    public String b3Action() {
	include3Counter++;
	include3ChildRenderedFlag = false;
	return null;
    }

    public String b4Action() {
	setInclude4RenderedFlag(include4RenderedFlag ? false : true);
	return null;
    }

    public String reset() {
	include1Counter = 0;
	include2Counter = 0;
	include3Counter = 0;
	include3ChildRenderedFlag = true;
	include4RenderedFlag = true;
	return null;
    }

}
