/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.ajax4jsf.bean;

import java.util.ArrayList;
import java.util.List;

import org.richfaces.component.UIDataFltrSlider;
import org.richfaces.event.DataFilterSliderEvent;

public class DataFilterSliderBean {

    public static class Planet {
        private String name;

        private double gravity;

        Planet(String n, double g) {
            name = n;
            gravity = g;
        }

        public String getName() {
            return name;
        }

        public double getGravity() {
            return gravity;
        }
    }

    private UIDataFltrSlider slider;

    private List<Planet> planets;

    private String eventSnapshot = "";

    public DataFilterSliderBean() {
        planets = new ArrayList<Planet>();
        planets.add(new Planet("Sun", 27.94));
        planets.add(new Planet("Mercury", 0.3770));
        planets.add(new Planet("Venus", 0.9032));
        planets.add(new Planet("Earth", 1.0));
        planets.add(new Planet("Moon", 0.1655));
        planets.add(new Planet("Mars", 0.3895));
        planets.add(new Planet("Jupiter", 2.640));
        planets.add(new Planet("Saturn", 1.139));
        planets.add(new Planet("Uranus", 0.917));
        planets.add(new Planet("Neptune", 1.148));
        planets.add(new Planet("Pluto", 0.0621));
    }

    public List<Planet> getPlanets() {
        return planets;
    }

    public UIDataFltrSlider getSlider() {
        return slider;
    }

    public void setSlider(UIDataFltrSlider slider) {
        this.slider = slider;
    }

    public void doSlide(DataFilterSliderEvent event) {
        Integer oldSliderVal = event.getOldSliderVal();
        Integer newSliderVal = event.getNewSliderVal();
        eventSnapshot = "DataFilterSliderEvent[" + oldSliderVal + "," + newSliderVal + "]";
    }

    public String getEventSnapshot() {
        return eventSnapshot;
    }

    public Integer getSubmittedValue() {
        Integer retVal = null;
        if (slider != null) {
            retVal = (Integer) slider.getHandleValue();
        }

        return retVal;
    }

    public String reset() {
        eventSnapshot = "";
        return null;
    }

}
