/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AjaxFormTest extends SeleniumTestBase {

    private final static String TEST_URL = "pages/ajaxForm/ajaxFormTest.xhtml";

    private final static String FORM_ID = "a4j_form";

    private static final String STANDART_FORM = "staticForm";

    private final static String INNER_INPUT_ID = "inner_name";

    private final static String OUTER_INPUT_ID = "outer_name";

    private final static String TEST_FIELD_ID = "test_field_name";

    private final static String BUTTON_ID = "submit";

    private final static String PREV_TEXT = "before submit";

    private final static String NEXT_TEXT = "after submit";

    private final static String CHECK_ID_AJAXSUBMIT = "ajaxSubmit";

    private final static String CHECK_ID_IGNOREDUPRESPONSES = "ignoreDupResponses";

    private final static String CHECK_ID_PREPENDID = "prependId";

    private final static String CHECK_ID_RENDERED = "rendered";

    private final static String PANEL_GROUP = "content";

    private final static String RERENDER_ID = "rerender";

    private final static String LINK_ID = "link";

    @Test
    public void testAttrAjaxSubmit(Template template) throws Exception {
        renderPage(template);

        // clickOnCheckbox(CHECK_ID_AJAXSUBMIT, BUTTON_ID);
        test(BUTTON_ID, INNER_INPUT_ID, STANDART_FORM.concat(":").concat(OUTER_INPUT_ID), TEST_FIELD_ID, true, null,
                null, null, "testAttrAjaxSubmit");

        resetTestData();
    }

    @Test
    public void testAttrPrependId(Template template) {
        renderPage(template);

        if (!PREV_TEXT.equals(getValueById(getFullComponentId(INNER_INPUT_ID, "1")))) {
            assertFail(null, null, true, null, "testAttrPrependId");
        }

        resetTestData();
    }

    /*
     * @Test public void testAttrIgnoreDupResponses() { //TODO: will be
     * implemented in future }
     */

    /*
     * @Test public void testAttrTimeout() { //TODO: will be implemented in
     * future }
     */

    @Test
    public void testProcessingLinks(Template template) {
        renderPage(template);

        clickOnCheckbox(CHECK_ID_RENDERED, BUTTON_ID, "2");
        clickById(getParentId() + LINK_ID.concat("2"));
        waitForAjaxCompletion();
        if (!NEXT_TEXT.equals(getTextById(getParentId() + TEST_FIELD_ID.concat("2")))) {
            assertFail(null, null, null, null, "testProcessingLinks");
        }

        resetTestData();
    }

    private String getFullComponentId(String componentId, String index) {
        return getParentId() + FORM_ID + index + ":" + componentId + index;
    }

    private boolean isAjaxSubmitSuccessfull(String innerInputId, String outerInputId) {
        String innerText = getTextById(getParentId() + innerInputId);
        String outerText = getValueById(getParentId() + outerInputId);
        return (NEXT_TEXT.equals(innerText) && (PREV_TEXT.equals(outerText)));
    }

    private void submitForm(String buttonId) {
        writeStatus("Submit form");
        clickAjaxCommandAndWait(getParentId() + buttonId);
    }

    private void test(String buttonId, String innerInputId, String outerInputId, String testInputId,
            Boolean ajaxSubmit, Boolean ignoreDupResponses, Integer timeout, Boolean prependId, String testName) {
        setValueById(getParentId() + innerInputId, NEXT_TEXT);
        submitForm(buttonId);
        if (!isAjaxSubmitSuccessfull(testInputId, outerInputId)) {
            assertFail(ajaxSubmit, ignoreDupResponses, prependId, timeout, testName);
        }
    }

    private void assertFail(Boolean ajaxSubmit, Boolean ignoreDupResponses, Boolean prependId, Integer timeout,
            String testName) {
        Assert.fail("<a4j:form> [ajaxSubmit=" + ajaxSubmit + " ; ignoreDupResponses=" + ignoreDupResponses
                + " ; timeout=" + timeout + " ; prependId=" + prependId + "] test '" + testName + "' failure.");
    }

    private void clickOnCheckbox(String checkId, String bottonId, String index) {
        clickById(getParentId() + checkId + index);
        clickById(getParentId() + bottonId +index);
        waitForAjaxCompletion();
    }

    private void resetTestData() {
        clickAjaxCommandAndWait(getParentId() + "_form:reset");
    }

    public String getTestUrl() {
        return TEST_URL;
    }
}
