/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.annotations.Test;

public class AjaxHTMLCommandLinkTest extends SeleniumTestBase {

    private final static String IS_ACTION_INVOKED = "_form:_action";

    private final static String IS_LISTENER_INVOKED = "_form:_listener";

    private final static String SUBMITTED_VALUE = "_form:_submittedValue";

    @Test
    public void testAjaxHTMLCommandLinkComponent(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";
        String linkId = null;

        linkId = parentId + "l2";
        writeStatus("Click link 2");
        clickCommandAndWait(linkId);
        assertValueSubmitted(false);
        assertActionInvoked(false);
        assertListenerInvoked(false);

        linkId = parentId + "l3";
        writeStatus("Click link 3");
        clickCommandAndWait(linkId);
        assertValueSubmitted(false);
        assertActionInvoked(true);
        assertListenerInvoked(true);

        linkId = parentId + "l4";
        writeStatus("Click link 4");
        clickCommandAndWait(linkId);
        assertValueSubmitted(false);
        assertActionInvoked(true);
        assertListenerInvoked(true);

//        linkId = parentId + "l1";
//        writeStatus("Click link 1");
//        clickCommandAndWait(linkId);
//        assertValueSubmitted(true);
//        assertActionInvoked(true);
//        assertListenerInvoked(true);
    }

    private void assertValueSubmitted(boolean submitted) {
        if (submitted) {
            writeStatus("Check that a new value is submitted");
            AssertTextEquals(getParentId() + SUBMITTED_VALUE, "text", "A new value is not submitted");
        } else {
            writeStatus("Check that a new value is not submitted");
            AssertTextEquals(getParentId() + SUBMITTED_VALUE, "", "A new value is submitted");
        }
    }

    private void assertActionInvoked(boolean invoked) {
        if(invoked) {
            writeStatus("Check that action is invoked");
            AssertTextEquals(getParentId() + IS_ACTION_INVOKED, "true", "An action is not invoked");
        } else {
            writeStatus("Check that action is not invoked");
            AssertTextEquals(getParentId() + IS_ACTION_INVOKED, "false", "An action is invoked");
        }
    }

    private void assertListenerInvoked(boolean invoked) {
        if(invoked) {
            writeStatus("Check that listener is invoked");
            AssertTextEquals(getParentId() + IS_LISTENER_INVOKED, "true", "A listener is not invoked");
        } else {
            writeStatus("Check that listener is not invoked");
            AssertTextEquals(getParentId() + IS_LISTENER_INVOKED, "false", "A listener is invoked");
        }
    }

    @Override
    public String getTestUrl() {
        return "pages/ajaxHTMLCommandLink/ajaxHTMLLinkTest.xhtml";
    }

}
