/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.annotations.Test;

public class ColumnsTest extends SeleniumTestBase {

    private static final String DATA_TABLE = "table";

    private static final String APPLY_BUTTON = "apply";

    private static final String RESET_BUTTON = "reset";

    private static final String CTRL_FORM = "_controls";

    private static final String ROWS_COUNT_CTRL = "rows";

    private static final String COLUMNS_COUNT_CTRL = "rows";

    private static final String BEGIN_ROW = "begin";

    private static final String END_ROW = "end";

    @Test
    public void testColumnsComponentLayout(Template template) {
        renderPage(template);
        writeStatus("Testing columns component layout");

        String parentId = getParentId() + "_form:";
        String tableId = parentId + DATA_TABLE;

        writeStatus("Check columns count equals to 3 ");
        assertColumnsCount(3, tableId);

        writeStatus("Check rows count equals to 20 ");
        assertRowsCount(20, tableId);

        writeStatus("Check columns headers");

        AssertTextEquals("xpath=//table[@id='" + tableId + "']/tHead/tr[1]/th[1]", "header0");
        AssertTextEquals("xpath=//table[@id='" + tableId + "']/tHead/tr[1]/th[2]", "header1");
        AssertTextEquals("xpath=//table[@id='" + tableId + "']/tHead/tr[1]/th[3]", "header2");

        writeStatus("Check columns footers");

        AssertTextEquals("xpath=//table[@id='" + tableId + "']/tFoot/tr[1]/td[1]", "footer0");
        AssertTextEquals("xpath=//table[@id='" + tableId + "']/tFoot/tr[1]/td[2]", "footer1");
        AssertTextEquals("xpath=//table[@id='" + tableId + "']/tFoot/tr[1]/td[3]", "footer2");

    }

    @Test
    public void testColumnsComponentCoreAttributes(Template template) {
        renderPage(template);

        writeStatus("Testing columns component core attributes");

        String parentId = getParentId() + "_form:";
        String tableId = parentId + DATA_TABLE;

        writeStatus("Set columns count == 5, rows count == 10");
        adjustTableParams(10, 5, 0, 10);

        writeStatus("Check columns count equals to 5 ");
        assertColumnsCount(5, tableId);
        writeStatus("Check rows count equals to 10 ");
        assertRowsCount(10, tableId);

        writeStatus("Set begin column == 2, end column == 2, rows count = 2");
        adjustTableParams(2, 5, 2, 2);

        writeStatus("Only one column has to be rendered");
        assertColumnsCount(1, tableId);
        assertRowsCount(2, tableId);

        writeStatus("Set end column == 0. there have to be no rows and no columns in the table");
        adjustTableParams(10, 5, 10, 0);
        assertRowsCount(0, tableId);

        reset();
    }

    private void adjustTableParams(int rows, int columns, int begin, int end) {
        String ctrlForm = getParentId() + CTRL_FORM;
        type(ctrlForm + ":rows", String.valueOf(rows));
        type(ctrlForm + ":columns", String.valueOf(columns));
        type(ctrlForm + ":begin", String.valueOf(begin));
        type(ctrlForm + ":end", String.valueOf(end));
        clickAjaxCommandAndWait(ctrlForm + ":apply");
    }

    private void reset() {
        clickAjaxCommandAndWait(getParentId() + CTRL_FORM + ":reset");
    }

    @Override
    public String getTestUrl() {
        return "pages/columns/columnsTest.xhtml";
    }

}
