/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ComboBoxTest extends SeleniumTestBase {

    @Test
    public void testComboBoxComponent(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";

        String predefinedCBId = parentId + "predefined";
        String selectItemsCBId = parentId + "selectItems";
        String suggestionValuesCBId = parentId + "suggestionValues";

        writeStatus("check components' default labels");

        getTextById(predefinedCBId + "comboboxField").startsWith("Select a");
        getTextById(selectItemsCBId + "comboboxField").startsWith("Select a");
        getTextById(suggestionValuesCBId + "comboboxField").startsWith("Select a");

        writeStatus("check a combobox with predefined suggestions");

        clickById(predefinedCBId);
        writeStatus("type \"Hunt\"");

        type(predefinedCBId + "comboboxField", "Hunt");

        Assert.assertTrue(isVisibleById(predefinedCBId + "list"), "Component's pop-up must show up on key typing");

        clickById(predefinedCBId + "list");

        Assert.assertFalse(isVisibleById(predefinedCBId + "list"), "Component's pop-up has to be closed");
        AssertValueEquals(predefinedCBId + "comboboxValue", "Hunter");

        writeStatus("check a combobox with dynamic suggestions list");

        clickById(selectItemsCBId);

        writeStatus("verify \"directInputSuggestions\" component's attribute");

        writeStatus("type \"O\"");

        type(selectItemsCBId + "comboboxField", "O");

        Assert.assertTrue(isVisibleById(selectItemsCBId + "list"), "Component's pop-up must show up on key typing");
        AssertValueEquals(selectItemsCBId + "comboboxValue", "Oak");

        writeStatus("check a combobox with a simple String list as suggestions list");

        clickById(suggestionValuesCBId);
        writeStatus("type \"Ma\"");

        type(suggestionValuesCBId + "comboboxField", "Ma");
        Assert.assertTrue(isVisibleById(suggestionValuesCBId + "list"), "Component's pop-up must show up on key typing");

        clickById(suggestionValuesCBId + "list");

        Assert.assertFalse(isVisibleById(suggestionValuesCBId + "list"), "Component's pop-up has to be closed");
        AssertValueEquals(suggestionValuesCBId + "comboboxValue", "Maple");
    }

    public String getTestUrl() {
        return "pages/comboBox/comboBoxTest.xhtml";
    }

}