/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.annotations.Test;

public class DropDownMenuTest extends SeleniumTestBase {

    @Test
    public void testDropDownMenuComponent(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";
        String file = parentId + "file";
        String open = parentId + "open:anchor";
        String saveAs = parentId + "saveAs:anchor";
        String save = parentId + "save:anchor";
        String saveAll = parentId + "saveAll:anchor";
        String close = parentId + "close:anchor";
        String exit = parentId + "exit:anchor";
        String operation = parentId + "operation";

        writeStatus("Check menu item in ajax mode");

        selenium.mouseOver(file);
        selenium.mouseOver(saveAs);
        clickById(saveAll);

        AssertTextEquals(operation, "Save All");

        selenium.mouseOver(file);
        selenium.mouseOver(saveAs);
        clickById(save);

        AssertTextEquals(operation, "Save");

        writeStatus("Check the drop down menu closed");

        AssertNotVisible(save);
        AssertNotVisible(saveAs);

        writeStatus("Check menu item in server mode");

        selenium.mouseOver(file);
        clickCommandAndWait(close);

        AssertTextEquals(operation, "Close");

        writeStatus("Check menu item in 'none' mode");

        selenium.mouseOver(file);
        selenium.mouseOver(exit);
        clickById(exit);

        AssertTextEquals(operation, "Close");
        AssertNotVisible(exit);

    }

    public String getTestUrl() {
        return "pages/dropDownMenu/dropDownMenuTest.xhtml";
    }

}
