/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;


public class InputNumberSpinnerTest extends SeleniumTestBase {

    @Test
    public void testInputNumberSpinnerComponent(Template template) {
        renderPage(template);

        writeStatus("check whether the spinner is invariant with respect to pair of sequential opposite operations");
        
        //start value = 20
        String before = getSpinnerValue();
        clickUp();
        clickDown();
        String after = getSpinnerValue();
        Assert.assertEquals(before, after);
        Assert.assertEquals(after, "20");

        writeStatus("check upper bound and cycling");

        clickUp(); //+10
        clickUp(); //+10
        clickUp(); //+10
        clickUp(); //+10
        clickUp(); //+10
        Assert.assertEquals(getSpinnerValue(), "10");

        writeStatus("check lower bound and cycling");

        clickDown(); //-10
        Assert.assertEquals(getSpinnerValue(), "0");
        clickDown(); //-10
        Assert.assertEquals(getSpinnerValue(), "50");
        clickDown(); //-10
        Assert.assertEquals(getSpinnerValue(), "40");
    }

    private void clickUp() {
        String id = getParentId() + "_form:" + "spinnerButtons";
        selenium.fireEvent("xpath=//table[@id='" + id + "']/tbody/tr[1]/td", "mousedown");
        selenium.fireEvent("xpath=//table[@id='" + id + "']/tbody/tr[1]/td", "mouseup");
    }

    private void clickDown() {
        String id = getParentId() + "_form:" + "spinnerButtons";
        selenium.fireEvent("xpath=//table[@id='" + id + "']/tbody/tr[2]/td", "mousedown");
        selenium.fireEvent("xpath=//table[@id='" + id + "']/tbody/tr[2]/td", "mouseup");
    }

    private String getSpinnerValue() {
        return selenium.getValue("name=" + getParentId() + "_form:spinner");
    }

    public String getTestUrl() {
        return "pages/inputNumberSpinner/inputNumberSpinnerTest.xhtml";
    }

}
