/**
 * License Agreement.
 *
 * JBoss RichFaces - Ajax4jsf Component Library
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */ 
package org.richfaces.testng;

import org.ajax4jsf.template.Template;
import org.richfaces.SeleniumTestBase;
import org.testng.Assert;
import org.testng.annotations.Test;

import com.thoughtworks.selenium.SeleniumException;

public class TogglePanelTest extends SeleniumTestBase {

    @Test
    public void testTogglePanelComponentAjaxMode(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";

        String inputId = parentId + "_value";
        String outputId = parentId + "_value2";

        String controlNext = parentId + "ajax_next";
        String controlOne = parentId + "ajax_one";
        String controlTwo = parentId + "ajax_two";

        String oneFacet = parentId + "ajax_state_one";
        String twoFacet = parentId + "ajax_state_two";

        reset();

        writeStatus("Click on ajax controlNext");
        clickAjaxCommandAndWait(controlNext);
        // pause(6000, "panel_ajax");
        AssertValueEquals(inputId, "ajax_next");
        AssertTextEquals(outputId, "1");
        Assert.assertTrue(isVisibleById(twoFacet));
        try {
            getTextById(oneFacet);
            Assert.fail("Both of 'one' and 'two' states were rendered for ajax toggle panel.");
        } catch (SeleniumException se) {

        }

        writeStatus("Click on ajax controlOne");
        clickById(controlOne);
        waitForAjaxCompletion(5000);
        AssertValueEquals(inputId, "ajax_one");
        AssertTextEquals(outputId, "2");
        Assert.assertTrue(isVisibleById(oneFacet));
        try {
            getTextById(twoFacet);
            Assert.fail("Both of 'one' and 'two' states were rendered for ajax toggle panel.");
        } catch (SeleniumException se) {

        }

        writeStatus("Click on ajax controlTwo");
        clickById(controlTwo);
        waitForAjaxCompletion(5000);
        AssertValueEquals(inputId, "ajax_two");
        AssertTextEquals(outputId, "1");
        Assert.assertTrue(isVisibleById(twoFacet));
        try {
            getTextById(oneFacet);
            Assert.fail("Both of 'one' and 'two' states were rendered for ajax toggle panel.");
        } catch (SeleniumException se) {
        }
    }

    @Test
    public void testTogglePanelComponentServerMode(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";

        String inputId = parentId + "_value";
        String outputId = parentId + "_value2";

        String controlNext = parentId + "server_next";
        String controlOne = parentId + "server_one";
        String controlTwo = parentId + "server_two";
        String oneFacet = parentId + "server_state_one";
        String twoFacet = parentId + "server_state_two";

        reset();

        writeStatus("Click on controlNext");
        clickCommandAndWait(controlNext);
        AssertValueEquals(inputId, "server_next");
        AssertTextEquals(outputId, "1");
        Assert.assertTrue(isVisibleById(twoFacet));
        try {
            getTextById(oneFacet);
            Assert.fail("Both of 'one' and 'two' states were rendered for server toggle panel.");
        } catch (SeleniumException se) {

        }

        writeStatus("Click on server controlOne");
        clickCommandAndWait(controlOne);
        AssertValueEquals(inputId, "server_one");
        AssertTextEquals(outputId, "2");
        Assert.assertTrue(isVisibleById(oneFacet));
        try {
            getTextById(twoFacet);
            Assert.fail("Both of 'one' and 'two' states were rendered for server toggle panel.");
        } catch (SeleniumException se) {

        }

        writeStatus("Click on server controlTwo");
        clickCommandAndWait(controlTwo);
        AssertValueEquals(inputId, "server_two");
        AssertTextEquals(outputId, "3");
        Assert.assertTrue(isVisibleById(twoFacet));
        try {
            getTextById(oneFacet);
            Assert.fail("Both of 'one' and 'two' states were rendered for server toggle panel.");
        } catch (SeleniumException se) {
        }
    }

    @Test
    public void testTogglePanelComponentClientMode(Template template) {
        renderPage(template);

        String parentId = getParentId() + "_form:";

        String controlNext = parentId + "client_next";
        String controlOne = parentId + "client_one";
        String controlTwo = parentId + "client_two";
        String oneFacet = parentId + "client_state_one";
        String twoFacet = parentId + "client_state_two";

        writeStatus("Click on client controlNext");
        clickById(controlNext);
        Assert.assertTrue(isVisibleById(twoFacet));
        Assert.assertFalse(isVisibleById(oneFacet));

        writeStatus("Click on client controlOne");
        clickById(controlOne);
        Assert.assertTrue(isVisibleById(oneFacet));
        Assert.assertFalse(isVisibleById(twoFacet));

        writeStatus("Click on client controlTwo");
        clickById(controlTwo);
        Assert.assertTrue(isVisibleById(twoFacet));
        Assert.assertFalse(isVisibleById(oneFacet));
    }

    private void reset() {
        writeStatus("Clean bean values");
        clickAjaxCommandAndWait(getParentId() + "_form:clean");
    }

    public String getTestUrl() {
        return "pages/togglePanel/togglePanelTest.xhtml";
    }

}
